/*
 * Decompiled with CFR 0.152.
 */
package com.planbase.pdf.layoutmanager;

import com.planbase.pdf.layoutmanager.Utils;

public class XyOffset {
    public static final XyOffset ORIGIN = new XyOffset(0.0f, 0.0f){

        public int hashCode() {
            return 0;
        }
    };
    private final float x;
    private final float y;

    private XyOffset(float xCoord, float yCoord) {
        this.x = xCoord;
        this.y = yCoord;
    }

    public static XyOffset of(float x, float y) {
        if (x == 0.0f && y == 0.0f) {
            return ORIGIN;
        }
        return new XyOffset(x, y);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public XyOffset x(float newX) {
        return XyOffset.of(newX, this.y);
    }

    public XyOffset y(float newY) {
        return XyOffset.of(this.x, newY);
    }

    public XyOffset plusXMinusY(XyOffset that) {
        return XyOffset.of(this.x + that.x(), this.y - that.y());
    }

    public XyOffset maxXMinY(XyOffset that) {
        if (this.x >= that.x() && this.y <= that.y()) {
            return this;
        }
        if (this.x <= that.x() && this.y >= that.y()) {
            return that;
        }
        return XyOffset.of(this.x > that.x() ? this.x : that.x(), this.y < that.y() ? this.y : that.y());
    }

    public boolean lte(XyOffset that) {
        return this.x <= that.x() && this.y >= that.y();
    }

    public String toString() {
        return "XyOffset(" + this.x + " " + this.y + ")";
    }

    public int hashCode() {
        return Utils.floatHashCode(this.x) ^ Utils.floatHashCode(this.y);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof XyOffset) || this.hashCode() != other.hashCode()) {
            return false;
        }
        XyOffset that = (XyOffset)other;
        return this.x == that.x() && this.y == that.y();
    }
}

