/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;
import net.sf.jazzlib.ZipFile;
import net.sf.jazzlib.ZipInputStream;
import nl.siegmann.epublib.domain.LazyResource;
import nl.siegmann.epublib.domain.MediaType;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.Resources;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.CollectionUtil;
import nl.siegmann.epublib.util.ResourceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesLoader.class);
    private static final ZipEntry ERROR_ZIP_ENTRY = new ZipEntry("<error>");

    public static Resources loadResources(ZipFile zipFile, String defaultHtmlEncoding, List<MediaType> lazyLoadedTypes) throws IOException {
        Resources result = new Resources();
        Enumeration entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)entries.nextElement();
            if (zipEntry == null || zipEntry.isDirectory()) continue;
            String href = zipEntry.getName();
            Resource resource = ResourcesLoader.shouldLoadLazy(href, lazyLoadedTypes) ? new LazyResource(zipFile.getName(), zipEntry.getSize(), href) : ResourceUtil.createResource(zipEntry, zipFile.getInputStream(zipEntry));
            if (resource.getMediaType() == MediatypeService.XHTML) {
                resource.setInputEncoding(defaultHtmlEncoding);
            }
            result.add(resource);
        }
        return result;
    }

    private static boolean shouldLoadLazy(String href, Collection<MediaType> lazilyLoadedMediaTypes) {
        if (CollectionUtil.isEmpty(lazilyLoadedMediaTypes)) {
            return false;
        }
        MediaType mediaType = MediatypeService.determineMediaType(href);
        return lazilyLoadedMediaTypes.contains(mediaType);
    }

    public static Resources loadResources(InputStream in, String defaultHtmlEncoding) throws IOException {
        return ResourcesLoader.loadResources(new ZipInputStream(in), defaultHtmlEncoding);
    }

    public static Resources loadResources(ZipInputStream zipInputStream, String defaultHtmlEncoding) throws IOException {
        ZipEntry zipEntry;
        Resources result = new Resources();
        do {
            if ((zipEntry = ResourcesLoader.getNextZipEntry(zipInputStream)) == null || zipEntry == ERROR_ZIP_ENTRY || zipEntry.isDirectory()) continue;
            Resource resource = ResourceUtil.createResource(zipEntry, zipInputStream);
            if (resource.getMediaType() == MediatypeService.XHTML) {
                resource.setInputEncoding(defaultHtmlEncoding);
            }
            result.add(resource);
        } while (zipEntry != null);
        return result;
    }

    private static ZipEntry getNextZipEntry(ZipInputStream zipInputStream) throws IOException {
        ZipEntry result = ERROR_ZIP_ENTRY;
        try {
            result = zipInputStream.getNextEntry();
        }
        catch (ZipException e) {
            LOG.error(e.getMessage());
            zipInputStream.closeEntry();
        }
        return result;
    }

    public static Resources loadResources(ZipFile zipFile, String defaultHtmlEncoding) throws IOException {
        return ResourcesLoader.loadResources(zipFile, defaultHtmlEncoding, Collections.<MediaType>emptyList());
    }
}

