/*
 * Decompiled with CFR 0.152.
 */
package com.pro_crafting.tools.jasperreport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperCompileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileTask
implements Callable<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompileTask.class);
    private final File source;
    private final File destination;
    private final boolean verbose;

    CompileTask(File source, File destination, boolean verbose) {
        this.source = source;
        this.destination = destination;
        this.verbose = verbose;
    }

    @Override
    public Void call() throws Exception {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.destination));
             BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.source));){
            JasperCompileManager.compileReportToStream((InputStream)in, (OutputStream)out);
            if (this.verbose) {
                LOGGER.info("Compiling source file {}", (Object)this.source.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.cleanUpAndThrowError(this.destination, e);
        }
        return null;
    }

    private void cleanUpAndThrowError(File out, Exception e) throws JRException {
        LOGGER.error("Could not compile source file {}", (Object)this.source.getAbsolutePath(), (Object)e);
        if (out != null && out.exists()) {
            out.delete();
        }
        throw new JRException("Could not compile " + this.source.getAbsolutePath(), (Throwable)e);
    }
}

