/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SarifLogger
extends AutomaticBean
implements AuditListener {
    private static final int UNICODE_LENGTH = 4;
    private static final int UNICODE_ESCAPE_UPPER_LIMIT = 31;
    private static final int BUFFER_SIZE = 1024;
    private static final String MESSAGE_PLACEHOLDER = "${message}";
    private static final String SEVERITY_LEVEL_PLACEHOLDER = "${severityLevel}";
    private static final String URI_PLACEHOLDER = "${uri}";
    private static final String LINE_PLACEHOLDER = "${line}";
    private static final String COLUMN_PLACEHOLDER = "${column}";
    private static final String RULE_ID_PLACEHOLDER = "${ruleId}";
    private static final String VERSION_PLACEHOLDER = "${version}";
    private static final String RESULTS_PLACEHOLDER = "${results}";
    private final PrintWriter writer;
    private final boolean closeStream;
    private final List<String> results = new ArrayList<String>();
    private final String report;
    private final String resultLineColumn;
    private final String resultLineOnly;
    private final String resultFileOnly;
    private final String resultErrorOnly;

    public SarifLogger(OutputStream outputStream, AutomaticBean.OutputStreamOptions outputStreamOptions) throws IOException {
        if (outputStreamOptions == null) {
            throw new IllegalArgumentException("Parameter outputStreamOptions can not be null");
        }
        this.writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        this.closeStream = outputStreamOptions == AutomaticBean.OutputStreamOptions.CLOSE;
        this.report = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/SarifReport.template");
        this.resultLineColumn = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultLineColumn.template");
        this.resultLineOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultLineOnly.template");
        this.resultFileOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultFileOnly.template");
        this.resultErrorOnly = SarifLogger.readResource("/com/puppycrawl/tools/checkstyle/sarif/ResultErrorOnly.template");
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public void auditStarted(AuditEvent event) {
    }

    @Override
    public void auditFinished(AuditEvent event) {
        String version = SarifLogger.class.getPackage().getImplementationVersion();
        String rendered = this.report.replace(VERSION_PLACEHOLDER, String.valueOf(version)).replace(RESULTS_PLACEHOLDER, String.join((CharSequence)",\n", this.results));
        this.writer.print(rendered);
        if (this.closeStream) {
            this.writer.close();
        } else {
            this.writer.flush();
        }
    }

    @Override
    public void addError(AuditEvent event) {
        if (event.getColumn() > 0) {
            this.results.add(this.resultLineColumn.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, event.getFileName()).replace(COLUMN_PLACEHOLDER, Integer.toString(event.getColumn())).replace(LINE_PLACEHOLDER, Integer.toString(event.getLine())).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(event.getMessage())).replace(RULE_ID_PLACEHOLDER, event.getViolation().getKey()));
        } else {
            this.results.add(this.resultLineOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, event.getFileName()).replace(LINE_PLACEHOLDER, Integer.toString(event.getLine())).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(event.getMessage())).replace(RULE_ID_PLACEHOLDER, event.getViolation().getKey()));
        }
    }

    @Override
    public void addException(AuditEvent event, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printer = new PrintWriter(stringWriter);
        throwable.printStackTrace(printer);
        if (event.getFileName() == null) {
            this.results.add(this.resultErrorOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(stringWriter.toString())));
        } else {
            this.results.add(this.resultFileOnly.replace(SEVERITY_LEVEL_PLACEHOLDER, SarifLogger.renderSeverityLevel(event.getSeverityLevel())).replace(URI_PLACEHOLDER, event.getFileName()).replace(MESSAGE_PLACEHOLDER, SarifLogger.escape(stringWriter.toString())));
        }
    }

    @Override
    public void fileStarted(AuditEvent event) {
    }

    @Override
    public void fileFinished(AuditEvent event) {
    }

    private static String renderSeverityLevel(SeverityLevel severityLevel) {
        String renderedSeverityLevel;
        switch (severityLevel) {
            case IGNORE: {
                renderedSeverityLevel = "none";
                break;
            }
            case INFO: {
                renderedSeverityLevel = "note";
                break;
            }
            case WARNING: {
                renderedSeverityLevel = "warning";
                break;
            }
            default: {
                renderedSeverityLevel = "error";
            }
        }
        return renderedSeverityLevel;
    }

    public static String escape(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        block10: for (int i = 0; i < value.length(); ++i) {
            char chr = value.charAt(i);
            switch (chr) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (chr <= '\u001f') {
                        sb.append(SarifLogger.escapeUnicode1F(chr));
                        continue block10;
                    }
                    sb.append(chr);
                }
            }
        }
        return sb.toString();
    }

    private static String escapeUnicode1F(char chr) {
        String hexString = Integer.toHexString(chr);
        return "\\u" + "0".repeat(4 - hexString.length()) + hexString.toUpperCase(Locale.US);
    }

    public static String readResource(String name) throws IOException {
        try (InputStream inputStream = SarifLogger.class.getResourceAsStream(name);){
            String string;
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                if (inputStream == null) {
                    throw new IOException("Cannot find the resource " + name);
                }
                byte[] buffer = new byte[1024];
                int length = inputStream.read(buffer);
                while (length != -1) {
                    result.write(buffer, 0, length);
                    length = inputStream.read(buffer);
                }
                string = result.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
    }
}

