/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.RootNode;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

@StatelessCheck
public class MatchXpathCheck
extends AbstractCheck {
    public static final String MSG_KEY = "matchxpath.match";
    private String query = "";
    private XPathExpression xpathExpression;

    public void setQuery(String query) {
        this.query = query;
        if (!query.isEmpty()) {
            try {
                XPathEvaluator xpathEvaluator = new XPathEvaluator(Configuration.newConfiguration());
                this.xpathExpression = xpathEvaluator.createExpression(query);
            }
            catch (XPathException ex) {
                throw new IllegalStateException("Creating Xpath expression failed: " + query, ex);
            }
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        if (this.xpathExpression != null) {
            List<DetailAST> matchingNodes = this.findMatchingNodesByXpathQuery(rootAST);
            matchingNodes.forEach(node -> this.log((DetailAST)node, MSG_KEY, new Object[0]));
        }
    }

    private List<DetailAST> findMatchingNodesByXpathQuery(DetailAST rootAST) {
        try {
            RootNode rootNode = new RootNode(rootAST);
            XPathDynamicContext xpathDynamicContext = this.xpathExpression.createDynamicContext((Item)rootNode);
            List matchingItems = this.xpathExpression.evaluate(xpathDynamicContext);
            return matchingItems.stream().map(item -> (DetailAST)((AbstractNode)item).getUnderlyingNode()).collect(Collectors.toList());
        }
        catch (XPathException ex) {
            throw new IllegalStateException("Evaluation of Xpath query failed: " + this.query, ex);
        }
    }
}

