/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.metrics;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;

@FileStatefulCheck
public class CyclomaticComplexityCheck
extends AbstractCheck {
    public static final String MSG_KEY = "cyclomaticComplexity";
    private static final BigInteger INITIAL_VALUE = BigInteger.ONE;
    private static final int DEFAULT_COMPLEXITY_VALUE = 10;
    private final Deque<BigInteger> valueStack = new ArrayDeque<BigInteger>();
    private boolean switchBlockAsSingleDecisionPoint;
    private BigInteger currentValue = INITIAL_VALUE;
    private int max = 10;

    public void setSwitchBlockAsSingleDecisionPoint(boolean switchBlockAsSingleDecisionPoint) {
        this.switchBlockAsSingleDecisionPoint = switchBlockAsSingleDecisionPoint;
    }

    public final void setMax(int max) {
        this.max = max;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{8, 9, 11, 12, 84, 85, 91, 83, 89, 93, 96, 109, 111, 110, 203};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{8, 9, 11, 12, 84, 85, 91, 83, 89, 93, 96, 109, 111, 110, 203};
    }

    @Override
    public final int[] getRequiredTokens() {
        return new int[]{8, 9, 11, 12, 203};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 203: {
                this.visitMethodDef();
                break;
            }
            default: {
                this.visitTokenHook(ast);
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 203: {
                this.leaveMethodDef(ast);
                break;
            }
        }
    }

    private void visitTokenHook(DetailAST ast) {
        if (this.switchBlockAsSingleDecisionPoint) {
            if (ast.getType() != 93) {
                this.incrementCurrentValue(BigInteger.ONE);
            }
        } else if (ast.getType() != 89) {
            this.incrementCurrentValue(BigInteger.ONE);
        }
    }

    private void leaveMethodDef(DetailAST ast) {
        BigInteger bigIntegerMax = BigInteger.valueOf(this.max);
        if (this.currentValue.compareTo(bigIntegerMax) > 0) {
            this.log(ast, MSG_KEY, this.currentValue, bigIntegerMax);
        }
        this.popValue();
    }

    private void incrementCurrentValue(BigInteger amount) {
        this.currentValue = this.currentValue.add(amount);
    }

    private void pushValue() {
        this.valueStack.push(this.currentValue);
        this.currentValue = INITIAL_VALUE;
    }

    private void popValue() {
        this.currentValue = this.valueStack.pop();
    }

    private void visitMethodDef() {
        this.pushValue();
    }
}

