/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.BitSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class CommonUtil {
    public static final int DEFAULT_TAB_WIDTH = 8;
    public static final BitSet EMPTY_BIT_SET = new BitSet();
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final String CLASSPATH_URL_PROTOCOL = "classpath:";
    private static final String UNABLE_TO_FIND_EXCEPTION_PREFIX = "Unable to find: ";
    private static final String EXTENSION_SEPARATOR = ".";

    private CommonUtil() {
    }

    public static Pattern createPattern(String pattern) {
        return CommonUtil.createPattern(pattern, 0);
    }

    public static Pattern createPattern(String pattern, int flags) {
        try {
            return Pattern.compile(pattern, flags);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Failed to initialise regular expression " + pattern, ex);
        }
    }

    public static boolean matchesFileExtension(File file, String ... fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = extension.startsWith(EXTENSION_SEPARATOR) ? extension : EXTENSION_SEPARATOR + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean hasWhitespaceBefore(int index, String line) {
        boolean result = true;
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String inputString, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (inputString.codePointAt(idx) == 9) {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean isPatternValid(String pattern) {
        boolean isValid = true;
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException ignored) {
            isValid = false;
        }
        return isValid;
    }

    public static String baseClassName(String type) {
        int index = type.lastIndexOf(46);
        String className = index == -1 ? type : type.substring(index + 1);
        return className;
    }

    public static String relativizeAndNormalizePath(String baseDirectory, String path) {
        String resultPath;
        if (baseDirectory == null) {
            resultPath = path;
        } else {
            Path pathAbsolute = Paths.get(path, new String[0]).normalize();
            Path pathBase = Paths.get(baseDirectory, new String[0]).normalize();
            resultPath = pathBase.relativize(pathAbsolute).toString();
        }
        return resultPath;
    }

    public static <T> Constructor<T> getConstructor(Class<T> targetClass, Class<?> ... parameterTypes) {
        try {
            return targetClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot close the stream", ex);
            }
        }
    }

    public static URI getUriByFilename(String filename) throws CheckstyleException {
        URI uri = CommonUtil.getWebOrFileProtocolUri(filename);
        if (uri == null) {
            uri = CommonUtil.getFilepathOrClasspathUri(filename);
        }
        return uri;
    }

    public static URI getWebOrFileProtocolUri(String filename) {
        URI uri;
        try {
            URL url = new URL(filename);
            uri = url.toURI();
        }
        catch (MalformedURLException | URISyntaxException ignored) {
            uri = null;
        }
        return uri;
    }

    private static URI getFilepathOrClasspathUri(String filename) throws CheckstyleException {
        URI uri;
        File file = new File(filename);
        if (file.exists()) {
            uri = file.toURI();
        } else {
            int lastIndexOfClasspathProtocol = filename.lastIndexOf(CLASSPATH_URL_PROTOCOL) == 0 ? CLASSPATH_URL_PROTOCOL.length() : 0;
            uri = CommonUtil.getResourceFromClassPath(filename.substring(lastIndexOfClasspathProtocol));
        }
        return uri;
    }

    public static URI getResourceFromClassPath(String filename) throws CheckstyleException {
        URI uri;
        URL configUrl = filename.charAt(0) == '/' ? CommonUtil.getCheckstyleResource(filename) : ClassLoader.getSystemResource(filename);
        if (configUrl == null) {
            throw new CheckstyleException(UNABLE_TO_FIND_EXCEPTION_PREFIX + filename);
        }
        try {
            uri = configUrl.toURI();
        }
        catch (URISyntaxException ex) {
            throw new CheckstyleException(UNABLE_TO_FIND_EXCEPTION_PREFIX + filename, ex);
        }
        return uri;
    }

    public static URL getCheckstyleResource(String name) {
        return CommonUtil.class.getResource(name);
    }

    public static String fillTemplateWithStringsByRegexp(String template, String lineToPlaceInTemplate, Pattern regexp) {
        Matcher matcher = regexp.matcher(lineToPlaceInTemplate);
        String result = template;
        if (matcher.find()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replaceAll("\\$" + i, matcher.group(i));
            }
        }
        return result;
    }

    public static String getFileNameWithoutExtension(String fullFilename) {
        String fileName = new File(fullFilename).getName();
        int dotIndex = fileName.lastIndexOf(46);
        String fileNameWithoutExtension = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
        return fileNameWithoutExtension;
    }

    public static String getFileExtension(String fileNameWithExtension) {
        String fileName = Paths.get(fileNameWithExtension, new String[0]).toString();
        int dotIndex = fileName.lastIndexOf(46);
        String extension = dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
        return extension;
    }

    public static boolean isIdentifier(String str) {
        boolean isIdentifier = !str.isEmpty();
        for (int i = 0; isIdentifier && i < str.length(); ++i) {
            isIdentifier = i == 0 ? Character.isJavaIdentifierStart(str.charAt(0)) : Character.isJavaIdentifierPart(str.charAt(i));
        }
        return isIdentifier;
    }

    public static boolean isName(String str) {
        String identifier;
        String[] identifiers;
        boolean isName = false;
        String[] stringArray = identifiers = str.split("\\.", -1);
        int n = stringArray.length;
        for (int i = 0; i < n && (isName = CommonUtil.isIdentifier(identifier = stringArray[i])); ++i) {
        }
        return isName;
    }

    public static boolean isBlank(String value) {
        return Objects.isNull(value) || CommonUtil.indexOfNonWhitespace(value) >= value.length();
    }

    public static int indexOfNonWhitespace(String value) {
        int left;
        int codePointAt;
        int length = value.length();
        for (left = 0; left < length && Character.isWhitespace(codePointAt = value.codePointAt(left)); left += Character.charCount(codePointAt)) {
        }
        return left;
    }

    public static boolean isCodePointWhitespace(int[] codePoints, int index) {
        char character = Character.toChars(codePoints[index])[0];
        return Character.isWhitespace(character);
    }
}

