/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.module.xdoc.XdocSink;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="properties")
public class PropertiesMacro
extends AbstractMacro {
    private static final String PROPERTY_TYPES_XML = "property_types.xml";
    private static final String URL_F = "%s#%s";
    private static final String CODE_START = "<code>";
    private static final String CODE_END = "</code>";
    private static final String INDENT_LEVEL_10 = SiteUtil.getNewlineAndIndentSpaces(10);
    private static final String INDENT_LEVEL_12 = SiteUtil.getNewlineAndIndentSpaces(12);
    private static final String INDENT_LEVEL_14 = SiteUtil.getNewlineAndIndentSpaces(14);
    private static final String INDENT_LEVEL_16 = SiteUtil.getNewlineAndIndentSpaces(16);
    private static final String INDENT_LEVEL_18 = SiteUtil.getNewlineAndIndentSpaces(18);
    private static final String INDENT_LEVEL_20 = SiteUtil.getNewlineAndIndentSpaces(20);
    private static final String TOKENS_PROPERTY = "tokens";
    private static String currentModuleName = "";
    private static File currentModuleFile = new File("");

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        if (!(sink instanceof XdocSink)) {
            throw new MacroExecutionException("Expected Sink to be an XdocSink.");
        }
        String modulePath = (String)request.getParameter("modulePath");
        PropertiesMacro.configureGlobalProperties(modulePath);
        PropertiesMacro.writePropertiesTable((XdocSink)sink);
    }

    private static void configureGlobalProperties(String modulePath) {
        File moduleFile;
        currentModuleFile = moduleFile = new File(modulePath);
        currentModuleName = CommonUtil.getFileNameWithoutExtension(moduleFile.getName());
    }

    private static void writePropertiesTable(XdocSink sink) throws MacroExecutionException {
        sink.table();
        sink.setInsertNewline(false);
        sink.tableRows(null, false);
        sink.rawText(INDENT_LEVEL_12);
        PropertiesMacro.writeTableHeaderRow((Sink)sink);
        PropertiesMacro.writeTablePropertiesRows((Sink)sink);
        sink.rawText(INDENT_LEVEL_10);
        sink.tableRows_();
        sink.table_();
        sink.setInsertNewline(true);
    }

    private static void writeTableHeaderRow(Sink sink) {
        sink.tableRow();
        PropertiesMacro.writeTableHeaderCell(sink, "name");
        PropertiesMacro.writeTableHeaderCell(sink, "description");
        PropertiesMacro.writeTableHeaderCell(sink, "type");
        PropertiesMacro.writeTableHeaderCell(sink, "default value");
        PropertiesMacro.writeTableHeaderCell(sink, "since");
        sink.rawText(INDENT_LEVEL_12);
        sink.tableRow_();
    }

    private static void writeTableHeaderCell(Sink sink, String text) {
        sink.rawText(INDENT_LEVEL_14);
        sink.tableHeaderCell();
        sink.text(text);
        sink.tableHeaderCell_();
    }

    private static void writeTablePropertiesRows(Sink sink) throws MacroExecutionException {
        Object instance = SiteUtil.getModuleInstance(currentModuleName);
        Class<?> clss = instance.getClass();
        Set<String> properties = SiteUtil.getPropertiesForDocumentation(clss, instance);
        Map<String, DetailNode> propertiesJavadocs = SiteUtil.getPropertiesJavadocs(properties, currentModuleName, currentModuleFile);
        List<String> orderedProperties = PropertiesMacro.orderProperties(properties);
        for (String property : orderedProperties) {
            DetailNode propertyJavadoc = propertiesJavadocs.get(property);
            DetailNode currentModuleJavadoc = propertiesJavadocs.get(currentModuleName);
            PropertiesMacro.writePropertyRow(sink, property, propertyJavadoc, instance, currentModuleJavadoc);
        }
    }

    private static List<String> orderProperties(Set<String> properties) {
        LinkedList<String> orderProperties = new LinkedList<String>(properties);
        if (orderProperties.remove(TOKENS_PROPERTY)) {
            orderProperties.add(TOKENS_PROPERTY);
        }
        return List.copyOf(orderProperties);
    }

    private static void writePropertyRow(Sink sink, String propertyName, DetailNode propertyJavadoc, Object instance, DetailNode moduleJavadoc) throws MacroExecutionException {
        Field field = SiteUtil.getField(instance.getClass(), propertyName);
        sink.rawText(INDENT_LEVEL_12);
        sink.tableRow();
        PropertiesMacro.writePropertyNameCell(sink, propertyName);
        PropertiesMacro.writePropertyDescriptionCell(sink, propertyName, propertyJavadoc);
        PropertiesMacro.writePropertyTypeCell(sink, propertyName, field, instance);
        PropertiesMacro.writePropertyDefaultValueCell(sink, propertyName, field, instance);
        PropertiesMacro.writePropertySinceVersionCell(sink, propertyName, moduleJavadoc, propertyJavadoc);
        sink.rawText(INDENT_LEVEL_12);
        sink.tableRow_();
    }

    private static void writePropertyNameCell(Sink sink, String propertyName) {
        sink.rawText(INDENT_LEVEL_14);
        sink.tableCell();
        sink.text(propertyName);
        sink.tableCell_();
    }

    private static void writePropertyDescriptionCell(Sink sink, String propertyName, DetailNode propertyJavadoc) throws MacroExecutionException {
        sink.rawText(INDENT_LEVEL_14);
        sink.tableCell();
        String description = SiteUtil.getPropertyDescription(propertyName, propertyJavadoc, currentModuleName);
        sink.rawText(description);
        sink.tableCell_();
    }

    private static void writePropertyTypeCell(Sink sink, String propertyName, Field field, Object instance) throws MacroExecutionException {
        sink.rawText(INDENT_LEVEL_14);
        sink.tableCell();
        if (TOKENS_PROPERTY.equals(propertyName)) {
            AbstractCheck check = (AbstractCheck)instance;
            if (check.getRequiredTokens().length == 0 && Arrays.equals(check.getAcceptableTokens(), TokenUtil.getAllTokenIds())) {
                sink.text("set of any supported");
                PropertiesMacro.writeLink(sink);
            } else {
                List<String> configurableTokens = SiteUtil.getDifference(check.getAcceptableTokens(), check.getRequiredTokens()).stream().map(TokenUtil::getTokenName).collect(Collectors.toList());
                sink.text("subset of tokens");
                PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html");
            }
        } else if ("javadocTokens".equals(propertyName)) {
            AbstractJavadocCheck check = (AbstractJavadocCheck)instance;
            List<String> configurableTokens = SiteUtil.getDifference(check.getAcceptableJavadocTokens(), check.getRequiredJavadocTokens()).stream().map(JavadocUtil::getTokenName).collect(Collectors.toList());
            sink.text("subset of javadoc tokens");
            PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/JavadocTokenTypes.html");
        } else {
            String type = SiteUtil.getType(field, propertyName, currentModuleName, instance);
            if (PropertyType.TOKEN_ARRAY.getDescription().equals(type)) {
                PropertiesMacro.processLinkForTokenTypes(sink);
            } else {
                String relativePathToPropertyTypes = SiteUtil.getLinkToDocument(currentModuleName, PROPERTY_TYPES_XML);
                String escapedType = type.replace("[", ".5B").replace("]", ".5D");
                String url = String.format(Locale.ROOT, URL_F, relativePathToPropertyTypes, escapedType);
                sink.link(url);
                sink.text(type);
                sink.link_();
            }
        }
        sink.tableCell_();
    }

    private static void processLinkForTokenTypes(Sink sink) throws MacroExecutionException {
        String link = SiteUtil.getLinkToDocument(currentModuleName, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html");
        sink.text("subset of tokens ");
        sink.link(link);
        sink.text("TokenTypes");
        sink.link_();
    }

    private static void writeLink(Sink sink) throws MacroExecutionException {
        sink.rawText(INDENT_LEVEL_16);
        String link = SiteUtil.getLinkToDocument(currentModuleName, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html");
        sink.link(link);
        sink.rawText(INDENT_LEVEL_20);
        sink.text(TOKENS_PROPERTY);
        sink.link_();
        sink.rawText(INDENT_LEVEL_14);
    }

    private static void writeTokensList(Sink sink, List<String> tokens, String tokenTypesLink) throws MacroExecutionException {
        for (int index = 0; index < tokens.size(); ++index) {
            String token = tokens.get(index);
            sink.rawText(INDENT_LEVEL_16);
            if (index != 0) {
                sink.text(", ");
            }
            PropertiesMacro.writeLinkToToken(sink, tokenTypesLink, token);
        }
        if (tokens.isEmpty()) {
            sink.rawText(CODE_START);
            sink.text("empty");
            sink.rawText(CODE_END);
        } else {
            sink.rawText(INDENT_LEVEL_18);
            sink.text(".");
            sink.rawText(INDENT_LEVEL_14);
        }
    }

    private static void writeLinkToToken(Sink sink, String document, String tokenName) throws MacroExecutionException {
        String link = SiteUtil.getLinkToDocument(currentModuleName, document) + "#" + tokenName;
        sink.link(link);
        sink.rawText(INDENT_LEVEL_20);
        sink.text(tokenName);
        sink.link_();
    }

    private static void writePropertyDefaultValueCell(Sink sink, String propertyName, Field field, Object instance) throws MacroExecutionException {
        sink.rawText(INDENT_LEVEL_14);
        sink.tableCell();
        if (TOKENS_PROPERTY.equals(propertyName)) {
            AbstractCheck check = (AbstractCheck)instance;
            if (check.getRequiredTokens().length == 0 && Arrays.equals(check.getDefaultTokens(), TokenUtil.getAllTokenIds())) {
                sink.text("TokenTypes");
            } else {
                List<String> configurableTokens = SiteUtil.getDifference(check.getDefaultTokens(), check.getRequiredTokens()).stream().map(TokenUtil::getTokenName).collect(Collectors.toList());
                PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/TokenTypes.html");
            }
        } else if ("javadocTokens".equals(propertyName)) {
            AbstractJavadocCheck check = (AbstractJavadocCheck)instance;
            List<String> configurableTokens = SiteUtil.getDifference(check.getDefaultJavadocTokens(), check.getRequiredJavadocTokens()).stream().map(JavadocUtil::getTokenName).collect(Collectors.toList());
            PropertiesMacro.writeTokensList(sink, configurableTokens, "apidocs/com/puppycrawl/tools/checkstyle/api/JavadocTokenTypes.html");
        } else {
            String defaultValue = SiteUtil.getDefaultValue(propertyName, field, instance, currentModuleName);
            sink.rawText(CODE_START);
            sink.text(defaultValue);
            sink.rawText(CODE_END);
        }
        sink.tableCell_();
    }

    private static void writePropertySinceVersionCell(Sink sink, String propertyName, DetailNode moduleJavadoc, DetailNode propertyJavadoc) throws MacroExecutionException {
        sink.rawText(INDENT_LEVEL_14);
        sink.tableCell();
        String sinceVersion = SiteUtil.getSinceVersion(currentModuleName, moduleJavadoc, propertyName, propertyJavadoc);
        sink.text(sinceVersion);
        sink.tableCell_();
    }
}

