/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CodePointUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.stream.IntStream;

@FileStatefulCheck
public class GenericWhitespaceCheck
extends AbstractCheck {
    public static final String MSG_WS_PRECEDED = "ws.preceded";
    public static final String MSG_WS_FOLLOWED = "ws.followed";
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    public static final String MSG_WS_ILLEGAL_FOLLOW = "ws.illegalFollow";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private int depth;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{172, 173};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.depth = 0;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 172: {
                this.processStart(ast);
                ++this.depth;
                break;
            }
            case 173: {
                this.processEnd(ast);
                --this.depth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + ast);
            }
        }
    }

    private void processEnd(DetailAST ast) {
        int[] line = this.getLineCodePoints(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + 1;
        if (before >= 0 && CommonUtil.isCodePointWhitespace(line, before) && !GenericWhitespaceCheck.containsWhitespaceBefore(before, line)) {
            this.log(ast, MSG_WS_PRECEDED, CLOSE_ANGLE_BRACKET);
        }
        if (after < line.length) {
            if (this.depth == 1) {
                this.processSingleGeneric(ast, line, after);
            } else {
                this.processNestedGenerics(ast, line, after);
            }
        }
    }

    private void processNestedGenerics(DetailAST ast, int[] line, int after) {
        int indexOfAmp = IntStream.range(after, line.length).filter(index -> line[index] == 38).findFirst().orElse(-1);
        if (indexOfAmp >= 1 && GenericWhitespaceCheck.containsWhitespaceBetween(after, indexOfAmp, line)) {
            if (indexOfAmp - after == 0) {
                this.log(ast, MSG_WS_NOT_PRECEDED, "&");
            } else if (indexOfAmp - after != 1) {
                this.log(ast, MSG_WS_FOLLOWED, CLOSE_ANGLE_BRACKET);
            }
        } else if (line[after] == 32) {
            this.log(ast, MSG_WS_FOLLOWED, CLOSE_ANGLE_BRACKET);
        }
    }

    private void processSingleGeneric(DetailAST ast, int[] line, int after) {
        char charAfter = Character.toChars(line[after])[0];
        if (GenericWhitespaceCheck.isGenericBeforeMethod(ast) || GenericWhitespaceCheck.isGenericBeforeCtorInvocation(ast)) {
            if (Character.isWhitespace(charAfter)) {
                this.log(ast, MSG_WS_FOLLOWED, CLOSE_ANGLE_BRACKET);
            }
        } else if (!GenericWhitespaceCheck.isCharacterValidAfterGenericEnd(charAfter)) {
            this.log(ast, MSG_WS_ILLEGAL_FOLLOW, CLOSE_ANGLE_BRACKET);
        }
    }

    private static boolean isGenericBeforeCtorInvocation(DetailAST ast) {
        DetailAST grandParent = ast.getParent().getParent();
        return grandParent.getType() == 136 || grandParent.getParent().getType() == 136;
    }

    private static boolean isGenericAfterNew(DetailAST ast) {
        DetailAST parent = ast.getParent();
        return parent.getParent().getType() == 136 && (parent.getNextSibling().getType() == 58 || parent.getNextSibling().getType() == 59 || parent.getNextSibling().getType() == 158);
    }

    private static boolean isGenericBeforeMethod(DetailAST ast) {
        return ast.getParent().getParent().getParent().getType() == 27 || GenericWhitespaceCheck.isAfterMethodReference(ast);
    }

    private static boolean isAfterMethodReference(DetailAST genericEnd) {
        return genericEnd.getParent().getParent().getType() == 180;
    }

    private void processStart(DetailAST ast) {
        int[] line = this.getLineCodePoints(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + 1;
        if (before >= 0) {
            DetailAST parent = ast.getParent();
            DetailAST grandparent = parent.getParent();
            if (grandparent.getType() == 8 || grandparent.getType() == 9 || GenericWhitespaceCheck.isGenericAfterNew(ast)) {
                if (!CommonUtil.isCodePointWhitespace(line, before)) {
                    this.log(ast, MSG_WS_NOT_PRECEDED, OPEN_ANGLE_BRACKET);
                }
            } else if (CommonUtil.isCodePointWhitespace(line, before) && !GenericWhitespaceCheck.containsWhitespaceBefore(before, line)) {
                this.log(ast, MSG_WS_PRECEDED, OPEN_ANGLE_BRACKET);
            }
        }
        if (after < line.length && CommonUtil.isCodePointWhitespace(line, after)) {
            this.log(ast, MSG_WS_FOLLOWED, OPEN_ANGLE_BRACKET);
        }
    }

    private static boolean containsWhitespaceBetween(int fromIndex, int toIndex, int ... line) {
        boolean result = true;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (CommonUtil.isCodePointWhitespace(line, i)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean containsWhitespaceBefore(int before, int ... line) {
        return before != 0 && CodePointUtil.hasWhitespaceBefore(before, line);
    }

    private static boolean isCharacterValidAfterGenericEnd(char charAfter) {
        return charAfter == '(' || charAfter == ')' || charAfter == ',' || charAfter == '[' || charAfter == '.' || charAfter == ':' || charAfter == ';' || Character.isWhitespace(charAfter);
    }
}

