/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.grammar;

import java.util.ArrayDeque;
import java.util.Deque;
import org.antlr.v4.runtime.Lexer;

public final class CompositeLexerContextCache {
    private final Deque<StringTemplateContext> stringTemplateContextStack = new ArrayDeque<StringTemplateContext>();
    private final Lexer lexer;

    public CompositeLexerContextCache(Lexer lexer) {
        this.lexer = lexer;
    }

    public void enterTemplateContext(int mode) {
        StringTemplateContext newContext = new StringTemplateContext(mode, 0);
        this.stringTemplateContextStack.push(newContext);
    }

    public void exitTemplateContext() {
        this.stringTemplateContextStack.pop();
    }

    public void updateLeftCurlyBraceContext() {
        if (this.isInStringTemplateContext()) {
            StringTemplateContext currentContext = this.stringTemplateContextStack.pop();
            StringTemplateContext newContext = new StringTemplateContext(currentContext.getMode(), currentContext.getCurlyBraceDepth() + 1);
            this.stringTemplateContextStack.push(newContext);
        }
    }

    public void updateRightCurlyBraceContext() {
        if (this.isInStringTemplateContext()) {
            StringTemplateContext currentContext = this.stringTemplateContextStack.peek();
            if (currentContext.getCurlyBraceDepth() == 0) {
                this.pushToModeStackWithMore(currentContext.getMode());
            } else {
                StringTemplateContext newContext = new StringTemplateContext(currentContext.getMode(), currentContext.getCurlyBraceDepth() - 1);
                this.stringTemplateContextStack.push(newContext);
            }
        }
    }

    private void pushToModeStackWithMore(int mode) {
        this.lexer.more();
        this.lexer.pushMode(mode);
    }

    private boolean isInStringTemplateContext() {
        return !this.stringTemplateContextStack.isEmpty();
    }

    private static final class StringTemplateContext {
        private final int mode;
        private final int curlyBraceDepth;

        private StringTemplateContext(int mode, int curlyBraceDepth) {
            this.mode = mode;
            this.curlyBraceDepth = curlyBraceDepth;
        }

        public int getMode() {
            return this.mode;
        }

        public int getCurlyBraceDepth() {
            return this.curlyBraceDepth;
        }
    }
}

