/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.CsvFilterElement;
import java.util.Objects;
import java.util.regex.Pattern;

public class SuppressFilterElement
implements Filter {
    private final Pattern fileRegexp;
    private final Pattern checkRegexp;
    private final Pattern messageRegexp;
    private final String moduleId;
    private final CsvFilterElement lineFilter;
    private final String linesCsv;
    private final CsvFilterElement columnFilter;
    private final String columnsCsv;

    public SuppressFilterElement(String files, String checks, String message, String modId, String lines, String columns) {
        this.fileRegexp = files == null ? null : Pattern.compile(files);
        this.checkRegexp = checks == null ? null : Pattern.compile(checks);
        this.messageRegexp = message == null ? null : Pattern.compile(message);
        this.moduleId = modId;
        this.linesCsv = lines;
        this.lineFilter = lines == null ? null : new CsvFilterElement(lines);
        this.columnsCsv = columns;
        this.columnFilter = columns == null ? null : new CsvFilterElement(columns);
    }

    public SuppressFilterElement(Pattern files, Pattern checks, Pattern message, String moduleId, String lines, String columns) {
        this.fileRegexp = files;
        this.checkRegexp = checks;
        this.messageRegexp = message;
        this.moduleId = moduleId;
        if (lines == null) {
            this.linesCsv = null;
            this.lineFilter = null;
        } else {
            this.linesCsv = lines;
            this.lineFilter = new CsvFilterElement(lines);
        }
        if (columns == null) {
            this.columnsCsv = null;
            this.columnFilter = null;
        } else {
            this.columnsCsv = columns;
            this.columnFilter = new CsvFilterElement(columns);
        }
    }

    @Override
    public boolean accept(AuditEvent event) {
        return !this.isFileNameAndModuleNameMatching(event) || !this.isMessageNameMatching(event) || !this.isLineAndColumnMatching(event);
    }

    private boolean isFileNameAndModuleNameMatching(AuditEvent event) {
        return !(event.getFileName() == null || this.fileRegexp != null && !this.fileRegexp.matcher(event.getFileName()).find() || event.getViolation() == null || this.moduleId != null && !this.moduleId.equals(event.getModuleId()) || this.checkRegexp != null && !this.checkRegexp.matcher(event.getSourceName()).find());
    }

    private boolean isMessageNameMatching(AuditEvent event) {
        return this.messageRegexp == null || this.messageRegexp.matcher(event.getMessage()).find();
    }

    private boolean isLineAndColumnMatching(AuditEvent event) {
        return this.lineFilter == null && this.columnFilter == null || this.lineFilter != null && this.lineFilter.accept(event.getLine()) || this.columnFilter != null && this.columnFilter.accept(event.getColumn());
    }

    public int hashCode() {
        return Objects.hash(SuppressFilterElement.getPatternSafely(this.fileRegexp), SuppressFilterElement.getPatternSafely(this.checkRegexp), SuppressFilterElement.getPatternSafely(this.messageRegexp), this.moduleId, this.linesCsv, this.columnsCsv);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SuppressFilterElement suppressElement = (SuppressFilterElement)other;
        return Objects.equals(SuppressFilterElement.getPatternSafely(this.fileRegexp), SuppressFilterElement.getPatternSafely(suppressElement.fileRegexp)) && Objects.equals(SuppressFilterElement.getPatternSafely(this.checkRegexp), SuppressFilterElement.getPatternSafely(suppressElement.checkRegexp)) && Objects.equals(SuppressFilterElement.getPatternSafely(this.messageRegexp), SuppressFilterElement.getPatternSafely(suppressElement.messageRegexp)) && Objects.equals(this.moduleId, suppressElement.moduleId) && Objects.equals(this.linesCsv, suppressElement.linesCsv) && Objects.equals(this.columnsCsv, suppressElement.columnsCsv);
    }

    private static String getPatternSafely(Pattern pattern) {
        String result = null;
        if (pattern != null) {
            result = pattern.pattern();
        }
        return result;
    }
}

