/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Set;
import javax.annotation.Nullable;

@StatelessCheck
public class JavadocParagraphCheck
extends AbstractJavadocCheck {
    public static final String MSG_TAG_AFTER = "javadoc.paragraph.tag.after";
    public static final String MSG_LINE_BEFORE = "javadoc.paragraph.line.before";
    public static final String MSG_REDUNDANT_PARAGRAPH = "javadoc.paragraph.redundant.paragraph";
    public static final String MSG_MISPLACED_TAG = "javadoc.paragraph.misplaced.tag";
    public static final String MSG_PRECEDED_BLOCK_TAG = "javadoc.paragraph.preceded.block.tag";
    private static final Set<String> BLOCK_TAGS = Set.of("address", "blockquote", "div", "dl", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ol", "p", "pre", "table", "ul");
    private boolean allowNewlineParagraph = true;

    public void setAllowNewlineParagraph(boolean value) {
        this.allowNewlineParagraph = value;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{6, 10001};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (ast.getType() == 6 && JavadocParagraphCheck.isEmptyLine(ast)) {
            this.checkEmptyLine(ast);
        } else if (ast.getType() == 10001 && (JavadocUtil.getFirstChild(ast).getType() == 10006 || JavadocUtil.getFirstChild(ast).getType() == 10008)) {
            this.checkParagraphTag(ast);
        }
    }

    private void checkEmptyLine(DetailNode newline) {
        DetailNode nearestToken = JavadocParagraphCheck.getNearestNode(newline);
        if (nearestToken.getType() == 10074 && !CommonUtil.isBlank(nearestToken.getText())) {
            this.log(newline.getLineNumber(), newline.getColumnNumber(), MSG_TAG_AFTER, new Object[0]);
        }
    }

    private void checkParagraphTag(DetailNode tag) {
        if (!JavadocParagraphCheck.isNestedParagraph(tag)) {
            DetailNode newLine = JavadocParagraphCheck.getNearestEmptyLine(tag);
            if (JavadocParagraphCheck.isFirstParagraph(tag)) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_REDUNDANT_PARAGRAPH, new Object[0]);
            } else if (newLine == null || tag.getLineNumber() - newLine.getLineNumber() != 1) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_LINE_BEFORE, new Object[0]);
            }
            String blockTagName = JavadocParagraphCheck.findFollowedBlockTagName(tag);
            if (blockTagName != null) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_PRECEDED_BLOCK_TAG, blockTagName);
            }
            if (!this.allowNewlineParagraph && JavadocParagraphCheck.isImmediatelyFollowedByNewLine(tag)) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_MISPLACED_TAG, new Object[0]);
            }
            if (JavadocParagraphCheck.isImmediatelyFollowedByText(tag)) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_MISPLACED_TAG, new Object[0]);
            }
        }
    }

    private static boolean isNestedParagraph(DetailNode tag) {
        boolean nested = false;
        for (DetailNode parent = tag; parent != null; parent = parent.getParent()) {
            if (parent.getType() != 10008) continue;
            nested = true;
            break;
        }
        return nested;
    }

    @Nullable
    private static String findFollowedBlockTagName(DetailNode tag) {
        DetailNode htmlElement = JavadocParagraphCheck.findFirstHtmlElementAfter(tag);
        String blockTagName = null;
        if (htmlElement != null) {
            blockTagName = JavadocParagraphCheck.getHtmlElementName(htmlElement);
        }
        return blockTagName;
    }

    @Nullable
    private static DetailNode findFirstHtmlElementAfter(DetailNode tag) {
        DetailNode htmlElement = JavadocParagraphCheck.getNextSibling(tag);
        while (htmlElement != null && htmlElement.getType() != 10001 && htmlElement.getType() != 10005) {
            if (!(htmlElement.getType() != 10074 && htmlElement.getType() != 10072 || CommonUtil.isBlank(htmlElement.getText()))) {
                htmlElement = null;
                break;
            }
            htmlElement = JavadocUtil.getNextSibling(htmlElement);
        }
        return htmlElement;
    }

    @Nullable
    private static String getHtmlElementName(DetailNode htmlElement) {
        DetailNode htmlTag = htmlElement.getType() == 10005 ? htmlElement : JavadocUtil.getFirstChild(htmlElement);
        DetailNode htmlTagFirstChild = JavadocUtil.getFirstChild(htmlTag);
        DetailNode htmlTagName = JavadocUtil.findFirstToken(htmlTagFirstChild, 100);
        String blockTagName = null;
        if (htmlTagName != null && BLOCK_TAGS.contains(htmlTagName.getText())) {
            blockTagName = htmlTagName.getText();
        }
        return blockTagName;
    }

    private static DetailNode getNearestNode(DetailNode node) {
        DetailNode currentNode = node;
        while (currentNode.getType() == 1 || currentNode.getType() == 6) {
            currentNode = JavadocUtil.getNextSibling(currentNode);
        }
        return currentNode;
    }

    private static boolean isEmptyLine(DetailNode newLine) {
        boolean result = false;
        DetailNode previousSibling = JavadocUtil.getPreviousSibling(newLine);
        if (previousSibling != null && previousSibling.getParent().getType() == 10000) {
            if (previousSibling.getType() == 10074 && CommonUtil.isBlank(previousSibling.getText())) {
                previousSibling = JavadocUtil.getPreviousSibling(previousSibling);
            }
            result = previousSibling != null && previousSibling.getType() == 1;
        }
        return result;
    }

    private static boolean isFirstParagraph(DetailNode paragraphTag) {
        boolean result = true;
        DetailNode previousNode = JavadocUtil.getPreviousSibling(paragraphTag);
        while (previousNode != null) {
            if (previousNode.getType() == 10074 && !CommonUtil.isBlank(previousNode.getText()) || previousNode.getType() != 1 && previousNode.getType() != 6 && previousNode.getType() != 10074) {
                result = false;
                break;
            }
            previousNode = JavadocUtil.getPreviousSibling(previousNode);
        }
        return result;
    }

    private static DetailNode getNearestEmptyLine(DetailNode node) {
        DetailNode newLine = node;
        while (newLine != null) {
            DetailNode previousSibling = JavadocUtil.getPreviousSibling(newLine);
            if (newLine.getType() == 6 && JavadocParagraphCheck.isEmptyLine(newLine)) break;
            newLine = previousSibling;
        }
        return newLine;
    }

    private static boolean isImmediatelyFollowedByText(DetailNode tag) {
        DetailNode nextSibling = JavadocParagraphCheck.getNextSibling(tag);
        return nextSibling.getType() == -1 || nextSibling.getText().startsWith(" ");
    }

    private static boolean isImmediatelyFollowedByNewLine(DetailNode tag) {
        return JavadocParagraphCheck.getNextSibling(tag).getType() == 6;
    }

    private static DetailNode getNextSibling(DetailNode tag) {
        DetailNode nextSibling;
        if (JavadocUtil.getFirstChild(tag).getType() == 10008) {
            DetailNode paragraphToken = JavadocUtil.getFirstChild(tag);
            DetailNode paragraphStartTagToken = JavadocUtil.getFirstChild(paragraphToken);
            nextSibling = JavadocUtil.getNextSibling(paragraphStartTagToken);
        } else {
            nextSibling = JavadocUtil.getNextSibling(tag);
        }
        if (nextSibling.getType() == 10073) {
            nextSibling = JavadocUtil.getNextSibling(nextSibling);
        }
        return nextSibling;
    }
}

