/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.XmlLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportControl;
import com.puppycrawl.tools.checkstyle.checks.imports.AbstractImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.ClassImportRule;
import com.puppycrawl.tools.checkstyle.checks.imports.FileImportControl;
import com.puppycrawl.tools.checkstyle.checks.imports.MismatchStrategy;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgImportControl;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgImportRule;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ImportControlLoader
extends XmlLoader {
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Import Control 1.0//EN";
    private static final String DTD_PUBLIC_CS_ID_1_0 = "-//Checkstyle//DTD ImportControl Configuration 1.0//EN";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Import Control 1.1//EN";
    private static final String DTD_PUBLIC_CS_ID_1_1 = "-//Checkstyle//DTD ImportControl Configuration 1.1//EN";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Import Control 1.2//EN";
    private static final String DTD_PUBLIC_CS_ID_1_2 = "-//Checkstyle//DTD ImportControl Configuration 1.2//EN";
    private static final String DTD_PUBLIC_ID_1_3 = "-//Puppy Crawl//DTD Import Control 1.3//EN";
    private static final String DTD_PUBLIC_CS_ID_1_3 = "-//Checkstyle//DTD ImportControl Configuration 1.3//EN";
    private static final String DTD_PUBLIC_ID_1_4 = "-//Puppy Crawl//DTD Import Control 1.4//EN";
    private static final String DTD_PUBLIC_CS_ID_1_4 = "-//Checkstyle//DTD ImportControl Configuration 1.4//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_0.dtd";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_1.dtd";
    private static final String DTD_RESOURCE_NAME_1_2 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_2.dtd";
    private static final String DTD_RESOURCE_NAME_1_3 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_3.dtd";
    private static final String DTD_RESOURCE_NAME_1_4 = "com/puppycrawl/tools/checkstyle/checks/imports/import_control_1_4.dtd";
    private static final Map<String, String> DTD_RESOURCE_BY_ID = new HashMap<String, String>();
    private static final String PKG_ATTRIBUTE_NAME = "pkg";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String STRATEGY_ON_MISMATCH_ATTRIBUTE_NAME = "strategyOnMismatch";
    private static final String STRATEGY_ON_MISMATCH_ALLOWED_VALUE = "allowed";
    private static final String STRATEGY_ON_MISMATCH_DISALLOWED_VALUE = "disallowed";
    private static final String SUBPACKAGE_ELEMENT_NAME = "subpackage";
    private static final String FILE_ELEMENT_NAME = "file";
    private static final String ALLOW_ELEMENT_NAME = "allow";
    private final Deque<AbstractImportControl> stack = new ArrayDeque<AbstractImportControl>();

    private ImportControlLoader() throws ParserConfigurationException, SAXException {
        super(DTD_RESOURCE_BY_ID);
    }

    @Override
    public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("import-control".equals(qName)) {
            String pkg = ImportControlLoader.safeGet(attributes, PKG_ATTRIBUTE_NAME);
            MismatchStrategy strategyOnMismatch = ImportControlLoader.getStrategyForImportControl(attributes);
            boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
            this.stack.push(new PkgImportControl(pkg, regex, strategyOnMismatch));
        } else if (SUBPACKAGE_ELEMENT_NAME.equals(qName)) {
            String name = ImportControlLoader.safeGet(attributes, NAME_ATTRIBUTE_NAME);
            MismatchStrategy strategyOnMismatch = ImportControlLoader.getStrategyForSubpackage(attributes);
            boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
            PkgImportControl parentImportControl = (PkgImportControl)this.stack.peek();
            PkgImportControl importControl = new PkgImportControl(parentImportControl, name, regex, strategyOnMismatch);
            parentImportControl.addChild(importControl);
            this.stack.push(importControl);
        } else if (FILE_ELEMENT_NAME.equals(qName)) {
            String name = ImportControlLoader.safeGet(attributes, NAME_ATTRIBUTE_NAME);
            boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
            PkgImportControl parentImportControl = (PkgImportControl)this.stack.peek();
            FileImportControl importControl = new FileImportControl(parentImportControl, name, regex);
            parentImportControl.addChild(importControl);
            this.stack.push(importControl);
        } else if (ALLOW_ELEMENT_NAME.equals(qName) || "disallow".equals(qName)) {
            AbstractImportRule rule = ImportControlLoader.createImportRule(qName, attributes);
            this.stack.peek().addImportRule(rule);
        }
    }

    private static AbstractImportRule createImportRule(String qName, Attributes attributes) throws SAXException {
        AbstractImportRule rule;
        boolean isAllow = ALLOW_ELEMENT_NAME.equals(qName);
        boolean isLocalOnly = attributes.getValue("local-only") != null;
        String pkg = attributes.getValue(PKG_ATTRIBUTE_NAME);
        boolean regex = ImportControlLoader.containsRegexAttribute(attributes);
        if (pkg == null) {
            String clazz = ImportControlLoader.safeGet(attributes, "class");
            rule = new ClassImportRule(isAllow, isLocalOnly, clazz, regex);
        } else {
            boolean exactMatch = attributes.getValue("exact-match") != null;
            rule = new PkgImportRule(isAllow, isLocalOnly, pkg, exactMatch, regex);
        }
        return rule;
    }

    private static boolean containsRegexAttribute(Attributes attributes) {
        return attributes.getValue("regex") != null;
    }

    @Override
    public void endElement(String namespaceUri, String localName, String qName) {
        if (SUBPACKAGE_ELEMENT_NAME.equals(qName) || FILE_ELEMENT_NAME.equals(qName)) {
            this.stack.pop();
        }
    }

    public static PkgImportControl load(URI uri) throws CheckstyleException {
        return ImportControlLoader.loadUri(uri);
    }

    private static PkgImportControl load(InputSource source, URI uri) throws CheckstyleException {
        try {
            ImportControlLoader loader = new ImportControlLoader();
            loader.parseInputSource(source);
            return loader.getRoot();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new CheckstyleException("unable to parse " + uri + " - " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new CheckstyleException("unable to read " + uri, ex);
        }
    }

    private static PkgImportControl loadUri(URI uri) throws CheckstyleException {
        PkgImportControl pkgImportControl;
        block9: {
            InputStream inputStream = uri.toURL().openStream();
            try {
                InputSource source = new InputSource(inputStream);
                pkgImportControl = ImportControlLoader.load(source, uri);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException ex) {
                    throw new CheckstyleException("syntax error in url " + uri, ex);
                }
                catch (IOException ex) {
                    throw new CheckstyleException("unable to find " + uri, ex);
                }
            }
            inputStream.close();
        }
        return pkgImportControl;
    }

    private PkgImportControl getRoot() {
        return (PkgImportControl)this.stack.peek();
    }

    private static MismatchStrategy getStrategyForImportControl(Attributes attributes) {
        String returnValue = attributes.getValue(STRATEGY_ON_MISMATCH_ATTRIBUTE_NAME);
        MismatchStrategy strategyOnMismatch = MismatchStrategy.DISALLOWED;
        if (STRATEGY_ON_MISMATCH_ALLOWED_VALUE.equals(returnValue)) {
            strategyOnMismatch = MismatchStrategy.ALLOWED;
        }
        return strategyOnMismatch;
    }

    private static MismatchStrategy getStrategyForSubpackage(Attributes attributes) {
        String returnValue = attributes.getValue(STRATEGY_ON_MISMATCH_ATTRIBUTE_NAME);
        MismatchStrategy strategyOnMismatch = MismatchStrategy.DELEGATE_TO_PARENT;
        if (STRATEGY_ON_MISMATCH_ALLOWED_VALUE.equals(returnValue)) {
            strategyOnMismatch = MismatchStrategy.ALLOWED;
        } else if (STRATEGY_ON_MISMATCH_DISALLOWED_VALUE.equals(returnValue)) {
            strategyOnMismatch = MismatchStrategy.DISALLOWED;
        }
        return strategyOnMismatch;
    }

    private static String safeGet(Attributes attributes, String name) throws SAXException {
        String returnValue = attributes.getValue(name);
        if (returnValue == null) {
            throw new SAXException("missing attribute " + name);
        }
        return returnValue;
    }

    static {
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_2, DTD_RESOURCE_NAME_1_2);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_3, DTD_RESOURCE_NAME_1_3);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_ID_1_4, DTD_RESOURCE_NAME_1_4);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_CS_ID_1_0, DTD_RESOURCE_NAME_1_0);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_CS_ID_1_1, DTD_RESOURCE_NAME_1_1);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_CS_ID_1_2, DTD_RESOURCE_NAME_1_2);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_CS_ID_1_3, DTD_RESOURCE_NAME_1_3);
        DTD_RESOURCE_BY_ID.put(DTD_PUBLIC_CS_ID_1_4, DTD_RESOURCE_NAME_1_4);
    }
}

