/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

@FileStatefulCheck
public class RequireThisCheck
extends AbstractCheck {
    public static final String MSG_METHOD = "require.this.method";
    public static final String MSG_VARIABLE = "require.this.variable";
    private static final BitSet DECLARATION_TOKENS = TokenUtil.asBitSet(10, 8, 9, 14, 154, 157, 15, 21, 164, 199, 202, 178);
    private static final BitSet ASSIGN_TOKENS = TokenUtil.asBitSet(80, 98, 100, 101, 102, 103, 104, 105, 106, 107);
    private static final BitSet COMPOUND_ASSIGN_TOKENS = TokenUtil.asBitSet(98, 100, 101, 102, 103, 104, 105, 106, 107);
    private final Deque<AbstractFrame> current = new ArrayDeque<AbstractFrame>();
    private Map<DetailAST, AbstractFrame> frames;
    private boolean checkFields = true;
    private boolean checkMethods = true;
    private boolean validateOnlyOverlapping = true;

    public void setCheckFields(boolean checkFields) {
        this.checkFields = checkFields;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }

    public void setValidateOnlyOverlapping(boolean validateOnlyOverlapping) {
        this.validateOnlyOverlapping = validateOnlyOverlapping;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 154, 157, 8, 9, 91, 7, 58, 199, 203, 95, 178};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.frames = new HashMap<DetailAST, AbstractFrame>();
        this.current.clear();
        LinkedList<AbstractFrame> frameStack = new LinkedList<AbstractFrame>();
        DetailAST curNode = rootAST;
        while (curNode != null) {
            RequireThisCheck.collectDeclarations(frameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(frameStack, curNode);
                toVisit = curNode.getNextSibling();
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 58: {
                this.processIdent(ast);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 91: 
            case 154: 
            case 157: 
            case 199: {
                this.current.push(this.frames.get(ast));
                break;
            }
            case 95: {
                if (ast.getFirstChild().getType() != 176) break;
                this.current.push(this.frames.get(ast));
                break;
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 91: 
            case 154: 
            case 157: 
            case 199: {
                this.current.pop();
                break;
            }
            case 95: {
                if (this.current.peek().getType() != FrameType.TRY_WITH_RESOURCES_FRAME) break;
                this.current.pop();
                break;
            }
        }
    }

    private void processIdent(DetailAST ast) {
        int parentType = ast.getParent().getType();
        if (parentType == 28 && ast.getParent().getParent().getParent().getType() == 161) {
            parentType = 161;
        }
        switch (parentType) {
            case 159: 
            case 160: 
            case 161: {
                break;
            }
            case 27: {
                AbstractFrame frame;
                if (!this.checkMethods || (frame = this.getMethodWithoutThis(ast)) == null) break;
                this.logViolation(MSG_METHOD, ast, frame);
                break;
            }
            default: {
                boolean canUseThis;
                if (!this.checkFields) break;
                AbstractFrame frame = this.getFieldWithoutThis(ast, parentType);
                boolean bl = canUseThis = !RequireThisCheck.isInCompactConstructor(ast);
                if (frame == null || !canUseThis) break;
                this.logViolation(MSG_VARIABLE, ast, frame);
            }
        }
    }

    private void logViolation(String msgKey, DetailAST ast, AbstractFrame frame) {
        if (frame.getFrameName().equals(this.getNearestClassFrameName())) {
            this.log(ast, msgKey, ast.getText(), "");
        } else if (!(frame instanceof AnonymousClassFrame)) {
            this.log(ast, msgKey, ast.getText(), frame.getFrameName() + ".");
        }
    }

    private AbstractFrame getFieldWithoutThis(DetailAST ast, int parentType) {
        AbstractFrame fieldFrame;
        boolean importOrPackage = ScopeUtil.getSurroundingScope(ast) == null;
        boolean typeName = parentType == 13 || parentType == 136;
        AbstractFrame frame = null;
        if (!(importOrPackage || typeName || RequireThisCheck.isDeclarationToken(parentType) || RequireThisCheck.isLambdaParameter(ast) || (fieldFrame = this.findClassFrame(ast, false)) == null || !((ClassFrame)fieldFrame).hasInstanceMember(ast))) {
            frame = this.getClassFrameWhereViolationIsFound(ast);
        }
        return frame;
    }

    private static boolean isInCompactConstructor(DetailAST ast) {
        boolean isInCompactCtor = false;
        for (DetailAST parent = ast.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 203) continue;
            isInCompactCtor = true;
            break;
        }
        return isInCompactCtor;
    }

    private static void collectDeclarations(Deque<AbstractFrame> frameStack, DetailAST ast) {
        AbstractFrame frame = frameStack.peek();
        switch (ast.getType()) {
            case 10: {
                RequireThisCheck.collectVariableDeclarations(ast, frame);
                break;
            }
            case 202: {
                DetailAST componentIdent = ast.findFirstToken(58);
                ((ClassFrame)frame).addInstanceMember(componentIdent);
                break;
            }
            case 21: {
                if (CheckUtil.isReceiverParameter(ast) || RequireThisCheck.isLambdaParameter(ast)) break;
                DetailAST parameterIdent = ast.findFirstToken(58);
                frame.addIdent(parameterIdent);
                break;
            }
            case 178: {
                DetailAST resourceIdent = ast.findFirstToken(58);
                if (resourceIdent == null) break;
                frame.addIdent(resourceIdent);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: 
            case 199: {
                DetailAST classFrameNameIdent = ast.findFirstToken(58);
                frameStack.addFirst(new ClassFrame(frame, classFrameNameIdent));
                break;
            }
            case 7: {
                frameStack.addFirst(new BlockFrame(frame, ast));
                break;
            }
            case 9: {
                RequireThisCheck.collectMethodDeclarations(frameStack, ast, frame);
                break;
            }
            case 8: 
            case 203: {
                DetailAST ctorFrameNameIdent = ast.findFirstToken(58);
                frameStack.addFirst(new ConstructorFrame(frame, ctorFrameNameIdent));
                break;
            }
            case 155: {
                DetailAST ident = ast.findFirstToken(58);
                ((ClassFrame)frame).addStaticMember(ident);
                break;
            }
            case 96: {
                CatchFrame catchFrame = new CatchFrame(frame, ast);
                frameStack.addFirst(catchFrame);
                break;
            }
            case 91: {
                ForFrame forFrame = new ForFrame(frame, ast);
                frameStack.addFirst(forFrame);
                break;
            }
            case 136: {
                if (!RequireThisCheck.isAnonymousClassDef(ast)) break;
                frameStack.addFirst(new AnonymousClassFrame(frame, ast.getFirstChild().toString()));
                break;
            }
            case 95: {
                if (ast.getFirstChild().getType() != 176) break;
                frameStack.addFirst(new TryWithResourcesFrame(frame, ast));
                break;
            }
        }
    }

    private static void collectVariableDeclarations(DetailAST ast, AbstractFrame frame) {
        DetailAST ident = ast.findFirstToken(58);
        if (frame.getType() == FrameType.CLASS_FRAME) {
            DetailAST mods = ast.findFirstToken(5);
            if (ScopeUtil.isInInterfaceBlock(ast) || mods.findFirstToken(64) != null) {
                ((ClassFrame)frame).addStaticMember(ident);
            } else {
                ((ClassFrame)frame).addInstanceMember(ident);
            }
        } else {
            frame.addIdent(ident);
        }
    }

    private static void collectMethodDeclarations(Deque<AbstractFrame> frameStack, DetailAST ast, AbstractFrame frame) {
        DetailAST methodFrameNameIdent = ast.findFirstToken(58);
        DetailAST mods = ast.findFirstToken(5);
        if (mods.findFirstToken(64) == null) {
            ((ClassFrame)frame).addInstanceMethod(methodFrameNameIdent);
        } else {
            ((ClassFrame)frame).addStaticMethod(methodFrameNameIdent);
        }
        frameStack.addFirst(new MethodFrame(frame, methodFrameNameIdent));
    }

    private void endCollectingDeclarations(Queue<AbstractFrame> frameStack, DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 91: 
            case 96: 
            case 154: 
            case 157: 
            case 199: 
            case 203: {
                this.frames.put(ast, frameStack.poll());
                break;
            }
            case 136: {
                if (!RequireThisCheck.isAnonymousClassDef(ast)) break;
                this.frames.put(ast, frameStack.poll());
                break;
            }
            case 95: {
                if (ast.getFirstChild().getType() != 176) break;
                this.frames.put(ast, frameStack.poll());
                break;
            }
        }
    }

    private static boolean isAnonymousClassDef(DetailAST ast) {
        DetailAST lastChild = ast.getLastChild();
        return lastChild != null && lastChild.getType() == 6;
    }

    private AbstractFrame getClassFrameWhereViolationIsFound(DetailAST ast) {
        AbstractFrame frameWhereViolationIsFound = null;
        AbstractFrame variableDeclarationFrame = this.findFrame(ast, false);
        FrameType variableDeclarationFrameType = variableDeclarationFrame.getType();
        DetailAST prevSibling = ast.getPreviousSibling();
        if (!(variableDeclarationFrameType != FrameType.CLASS_FRAME || this.validateOnlyOverlapping || prevSibling != null && RequireThisCheck.isInExpression(ast) || !this.canBeReferencedFromStaticContext(ast))) {
            frameWhereViolationIsFound = variableDeclarationFrame;
        } else if (variableDeclarationFrameType == FrameType.METHOD_FRAME) {
            if (this.isOverlappingByArgument(ast)) {
                if (!RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && !RequireThisCheck.isReturnedVariable(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast) && this.canAssignValueToClassField(ast)) {
                    frameWhereViolationIsFound = this.findFrame(ast, true);
                }
            } else if (!this.validateOnlyOverlapping && prevSibling == null && RequireThisCheck.isAssignToken(ast.getParent().getType()) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast) && this.canAssignValueToClassField(ast)) {
                frameWhereViolationIsFound = this.findFrame(ast, true);
            }
        } else if (variableDeclarationFrameType == FrameType.CTOR_FRAME && this.isOverlappingByArgument(ast) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast)) {
            frameWhereViolationIsFound = this.findFrame(ast, true);
        } else if (variableDeclarationFrameType == FrameType.BLOCK_FRAME && this.isOverlappingByLocalVariable(ast) && this.canAssignValueToClassField(ast) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && !RequireThisCheck.isReturnedVariable(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast)) {
            frameWhereViolationIsFound = this.findFrame(ast, true);
        }
        return frameWhereViolationIsFound;
    }

    private static boolean isInExpression(DetailAST ast) {
        return 59 == ast.getParent().getType() || 180 == ast.getParent().getType();
    }

    private static boolean isUserDefinedArrangementOfThis(AbstractFrame currentFrame, DetailAST ident) {
        DetailAST blockFrameNameIdent = currentFrame.getFrameNameIdent();
        DetailAST definitionToken = blockFrameNameIdent.getParent();
        DetailAST blockStartToken = definitionToken.findFirstToken(7);
        DetailAST blockEndToken = RequireThisCheck.getBlockEndToken(blockFrameNameIdent, blockStartToken);
        boolean userDefinedArrangementOfThis = false;
        Set<DetailAST> variableUsagesInsideBlock = RequireThisCheck.getAllTokensWhichAreEqualToCurrent(definitionToken, ident, blockEndToken.getLineNo());
        for (DetailAST variableUsage : variableUsagesInsideBlock) {
            DetailAST prevSibling = variableUsage.getPreviousSibling();
            if (prevSibling == null || prevSibling.getType() != 78) continue;
            userDefinedArrangementOfThis = true;
            break;
        }
        return userDefinedArrangementOfThis;
    }

    private static DetailAST getBlockEndToken(DetailAST blockNameIdent, DetailAST blockStartToken) {
        DetailAST blockEndToken = null;
        DetailAST blockNameIdentParent = blockNameIdent.getParent();
        if (blockNameIdentParent.getType() == 33) {
            blockEndToken = blockNameIdentParent.getNextSibling();
        } else {
            Set<DetailAST> rcurlyTokens = RequireThisCheck.getAllTokensOfType(blockNameIdent, 73);
            for (DetailAST currentRcurly : rcurlyTokens) {
                DetailAST parent = currentRcurly.getParent();
                if (!TokenUtil.areOnSameLine(blockStartToken, parent)) continue;
                blockEndToken = currentRcurly;
            }
        }
        return blockEndToken;
    }

    private static boolean isReturnedVariable(AbstractFrame currentFrame, DetailAST ident) {
        DetailAST blockFrameNameIdent = currentFrame.getFrameNameIdent();
        DetailAST definitionToken = blockFrameNameIdent.getParent();
        DetailAST blockStartToken = definitionToken.findFirstToken(7);
        DetailAST blockEndToken = RequireThisCheck.getBlockEndToken(blockFrameNameIdent, blockStartToken);
        Set<DetailAST> returnsInsideBlock = RequireThisCheck.getAllTokensOfType(definitionToken, 88, blockEndToken.getLineNo());
        return returnsInsideBlock.stream().anyMatch(returnToken -> RequireThisCheck.isAstInside(returnToken, ident));
    }

    private static boolean isAstInside(DetailAST tree, DetailAST ast) {
        boolean result = false;
        if (RequireThisCheck.isAstSimilar(tree, ast)) {
            result = true;
        } else {
            for (DetailAST child = tree.getFirstChild(); child != null && !result; child = child.getNextSibling()) {
                result = RequireThisCheck.isAstInside(child, ast);
            }
        }
        return result;
    }

    private boolean canBeReferencedFromStaticContext(DetailAST ident) {
        AbstractFrame variableDeclarationFrame = this.findFrame(ident, false);
        while (variableDeclarationFrame.getType() == FrameType.BLOCK_FRAME || variableDeclarationFrame.getType() == FrameType.FOR_FRAME) {
            variableDeclarationFrame = variableDeclarationFrame.getParent();
        }
        boolean staticContext = false;
        if (variableDeclarationFrame.getType() == FrameType.CLASS_FRAME) {
            DetailAST codeBlockDefinition = RequireThisCheck.getCodeBlockDefinitionToken(ident);
            if (codeBlockDefinition != null) {
                DetailAST modifiers = codeBlockDefinition.getFirstChild();
                staticContext = codeBlockDefinition.getType() == 12 || modifiers.findFirstToken(64) != null;
            }
        } else {
            DetailAST frameNameIdent = variableDeclarationFrame.getFrameNameIdent();
            DetailAST definitionToken = frameNameIdent.getParent();
            staticContext = definitionToken.findFirstToken(5).findFirstToken(64) != null;
        }
        return !staticContext;
    }

    private static DetailAST getCodeBlockDefinitionToken(DetailAST ident) {
        DetailAST parent;
        for (parent = ident.getParent(); parent != null && parent.getType() != 9 && parent.getType() != 12; parent = parent.getParent()) {
        }
        return parent;
    }

    private boolean canAssignValueToClassField(DetailAST ast) {
        AbstractFrame fieldUsageFrame = this.findFrame(ast, false);
        boolean fieldUsageInConstructor = RequireThisCheck.isInsideConstructorFrame(fieldUsageFrame);
        AbstractFrame declarationFrame = this.findFrame(ast, true);
        boolean finalField = ((ClassFrame)declarationFrame).hasFinalField(ast);
        return fieldUsageInConstructor || !finalField;
    }

    private static boolean isInsideConstructorFrame(AbstractFrame frame) {
        AbstractFrame fieldUsageFrame = frame;
        while (fieldUsageFrame.getType() == FrameType.BLOCK_FRAME) {
            fieldUsageFrame = fieldUsageFrame.getParent();
        }
        return fieldUsageFrame.getType() == FrameType.CTOR_FRAME;
    }

    private boolean isOverlappingByArgument(DetailAST ast) {
        boolean overlapping = false;
        DetailAST parent = ast.getParent();
        DetailAST sibling = ast.getNextSibling();
        if (sibling != null && RequireThisCheck.isAssignToken(parent.getType())) {
            if (RequireThisCheck.isCompoundAssignToken(parent.getType())) {
                overlapping = true;
            } else {
                ClassFrame classFrame = (ClassFrame)this.findFrame(ast, true);
                Set<DetailAST> exprIdents = RequireThisCheck.getAllTokensOfType(sibling, 58);
                overlapping = classFrame.containsFieldOrVariableDef(exprIdents, ast);
            }
        }
        return overlapping;
    }

    private boolean isOverlappingByLocalVariable(DetailAST ast) {
        boolean overlapping = false;
        DetailAST parent = ast.getParent();
        if (RequireThisCheck.isAssignToken(parent.getType())) {
            ClassFrame classFrame = (ClassFrame)this.findFrame(ast, true);
            Set<DetailAST> exprIdents = RequireThisCheck.getAllTokensOfType(ast.getNextSibling(), 58);
            overlapping = classFrame.containsFieldOrVariableDef(exprIdents, ast);
        }
        return overlapping;
    }

    private static Set<DetailAST> getAllTokensOfType(DetailAST ast, int tokenType) {
        DetailAST vertex = ast;
        HashSet<DetailAST> result = new HashSet<DetailAST>();
        ArrayDeque<DetailAST> stack = new ArrayDeque<DetailAST>();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)stack.pop();
            }
            while (vertex != null) {
                if (vertex.getType() == tokenType) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    private static Set<DetailAST> getAllTokensOfType(DetailAST ast, int tokenType, int endLineNumber) {
        DetailAST vertex = ast;
        HashSet<DetailAST> result = new HashSet<DetailAST>();
        ArrayDeque<DetailAST> stack = new ArrayDeque<DetailAST>();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)stack.pop();
            }
            while (vertex != null) {
                if (tokenType == vertex.getType() && vertex.getLineNo() <= endLineNumber) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    private static Set<DetailAST> getAllTokensWhichAreEqualToCurrent(DetailAST ast, DetailAST token, int endLineNumber) {
        DetailAST vertex = ast;
        HashSet<DetailAST> result = new HashSet<DetailAST>();
        ArrayDeque<DetailAST> stack = new ArrayDeque<DetailAST>();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)stack.pop();
            }
            while (vertex != null) {
                if (RequireThisCheck.isAstSimilar(token, vertex) && vertex.getLineNo() <= endLineNumber) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    private AbstractFrame getMethodWithoutThis(DetailAST ast) {
        AbstractFrame frame;
        AbstractFrame result = null;
        if (!this.validateOnlyOverlapping && (frame = this.findFrame(ast, true)) != null && ((ClassFrame)frame).hasInstanceMethod(ast) && !((ClassFrame)frame).hasStaticMethod(ast)) {
            result = frame;
        }
        return result;
    }

    private AbstractFrame findClassFrame(DetailAST name, boolean lookForMethod) {
        AbstractFrame frame = this.current.peek();
        while ((frame = RequireThisCheck.findFrame(frame, name, lookForMethod)) != null && !(frame instanceof ClassFrame)) {
            frame = frame.getParent();
        }
        return frame;
    }

    private AbstractFrame findFrame(DetailAST name, boolean lookForMethod) {
        return RequireThisCheck.findFrame(this.current.peek(), name, lookForMethod);
    }

    private static AbstractFrame findFrame(AbstractFrame frame, DetailAST name, boolean lookForMethod) {
        return frame.getIfContains(name, lookForMethod);
    }

    private static boolean isDeclarationToken(int parentType) {
        return DECLARATION_TOKENS.get(parentType);
    }

    private static boolean isAssignToken(int tokenType) {
        return ASSIGN_TOKENS.get(tokenType);
    }

    private static boolean isCompoundAssignToken(int tokenType) {
        return COMPOUND_ASSIGN_TOKENS.get(tokenType);
    }

    private String getNearestClassFrameName() {
        AbstractFrame frame = this.current.peek();
        while (frame.getType() != FrameType.CLASS_FRAME) {
            frame = frame.getParent();
        }
        return frame.getFrameName();
    }

    private static boolean isLambdaParameter(DetailAST ast) {
        DetailAST lambdaParameters;
        DetailAST parent;
        for (parent = ast.getParent(); parent != null && parent.getType() != 181; parent = parent.getParent()) {
        }
        boolean isLambdaParameter = parent == null ? false : (ast.getType() == 21 ? true : ((lambdaParameters = parent.findFirstToken(20)) == null ? parent.getFirstChild().getText().equals(ast.getText()) : TokenUtil.findFirstTokenByPredicate(lambdaParameters, paramDef -> {
            DetailAST param = paramDef.findFirstToken(58);
            return param != null && param.getText().equals(ast.getText());
        }).isPresent()));
        return isLambdaParameter;
    }

    private static boolean isAstSimilar(DetailAST left, DetailAST right) {
        return left.getType() == right.getType() && left.getText().equals(right.getText());
    }

    private static class TryWithResourcesFrame
    extends AbstractFrame {
        protected TryWithResourcesFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        public FrameType getType() {
            return FrameType.TRY_WITH_RESOURCES_FRAME;
        }
    }

    private static class ForFrame
    extends AbstractFrame {
        protected ForFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        public FrameType getType() {
            return FrameType.FOR_FRAME;
        }
    }

    private static class CatchFrame
    extends AbstractFrame {
        protected CatchFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        public FrameType getType() {
            return FrameType.CATCH_FRAME;
        }

        @Override
        protected AbstractFrame getIfContains(DetailAST identToFind, boolean lookForMethod) {
            AbstractFrame frame = !lookForMethod && this.containsFieldOrVariable(identToFind) ? this : (this.getParent().getType() == FrameType.TRY_WITH_RESOURCES_FRAME ? this.getParent().getParent().getIfContains(identToFind, lookForMethod) : this.getParent().getIfContains(identToFind, lookForMethod));
            return frame;
        }
    }

    private static class BlockFrame
    extends AbstractFrame {
        protected BlockFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.BLOCK_FRAME;
        }
    }

    private static class AnonymousClassFrame
    extends ClassFrame {
        private final String frameName;

        protected AnonymousClassFrame(AbstractFrame parent, String frameName) {
            super(parent, null);
            this.frameName = frameName;
        }

        @Override
        protected String getFrameName() {
            return this.frameName;
        }
    }

    private static class ClassFrame
    extends AbstractFrame {
        private final Set<DetailAST> instanceMembers = new HashSet<DetailAST>();
        private final Set<DetailAST> instanceMethods = new HashSet<DetailAST>();
        private final Set<DetailAST> staticMembers = new HashSet<DetailAST>();
        private final Set<DetailAST> staticMethods = new HashSet<DetailAST>();

        private ClassFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.CLASS_FRAME;
        }

        public void addStaticMember(DetailAST ident) {
            this.staticMembers.add(ident);
        }

        public void addStaticMethod(DetailAST ident) {
            this.staticMethods.add(ident);
        }

        public void addInstanceMember(DetailAST ident) {
            this.instanceMembers.add(ident);
        }

        public void addInstanceMethod(DetailAST ident) {
            this.instanceMethods.add(ident);
        }

        public boolean hasInstanceMember(DetailAST ident) {
            return this.containsFieldOrVariableDef(this.instanceMembers, ident);
        }

        public boolean hasInstanceMethod(DetailAST ident) {
            return ClassFrame.containsMethodDef(this.instanceMethods, ident);
        }

        public boolean hasStaticMethod(DetailAST ident) {
            return ClassFrame.containsMethodDef(this.staticMethods, ident);
        }

        public boolean hasFinalField(DetailAST instanceMember) {
            boolean result = false;
            for (DetailAST member : this.instanceMembers) {
                DetailAST mods = member.getParent().findFirstToken(5);
                boolean finalMod = mods.findFirstToken(39) != null;
                if (!finalMod || !RequireThisCheck.isAstSimilar(member, instanceMember)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        protected boolean containsFieldOrVariable(DetailAST identToFind) {
            return this.containsFieldOrVariableDef(this.instanceMembers, identToFind) || this.containsFieldOrVariableDef(this.staticMembers, identToFind);
        }

        @Override
        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String identToFind = ident.getText();
            return identToFind.equals(ast.getText());
        }

        @Override
        protected AbstractFrame getIfContains(DetailAST identToFind, boolean lookForMethod) {
            AbstractFrame frame = null;
            if (lookForMethod && this.containsMethod(identToFind) || this.containsFieldOrVariable(identToFind)) {
                frame = this;
            } else if (this.getParent() != null) {
                frame = this.getParent().getIfContains(identToFind, lookForMethod);
            }
            return frame;
        }

        private boolean containsMethod(DetailAST methodToFind) {
            return ClassFrame.containsMethodDef(this.instanceMethods, methodToFind) || ClassFrame.containsMethodDef(this.staticMethods, methodToFind);
        }

        private static boolean containsMethodDef(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!ClassFrame.isSimilarSignature(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        private static boolean isSimilarSignature(DetailAST ident, DetailAST ast) {
            boolean result = false;
            DetailAST elistToken = ident.getParent().findFirstToken(34);
            if (elistToken != null && ident.getText().equals(ast.getText())) {
                int argsNumber;
                int paramsNumber = ast.getParent().findFirstToken(20).getChildCount();
                result = paramsNumber == (argsNumber = elistToken.getChildCount());
            }
            return result;
        }
    }

    private static class ConstructorFrame
    extends AbstractFrame {
        protected ConstructorFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.CTOR_FRAME;
        }
    }

    private static class MethodFrame
    extends AbstractFrame {
        protected MethodFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.METHOD_FRAME;
        }
    }

    private static abstract class AbstractFrame {
        private final Set<DetailAST> varIdents;
        private final AbstractFrame parent;
        private final DetailAST frameNameIdent;

        protected AbstractFrame(AbstractFrame parent, DetailAST ident) {
            this.parent = parent;
            this.frameNameIdent = ident;
            this.varIdents = new HashSet<DetailAST>();
        }

        protected abstract FrameType getType();

        private void addIdent(DetailAST identToAdd) {
            this.varIdents.add(identToAdd);
        }

        protected AbstractFrame getParent() {
            return this.parent;
        }

        protected String getFrameName() {
            return this.frameNameIdent.getText();
        }

        public DetailAST getFrameNameIdent() {
            return this.frameNameIdent;
        }

        protected boolean containsFieldOrVariable(DetailAST identToFind) {
            return this.containsFieldOrVariableDef(this.varIdents, identToFind);
        }

        protected AbstractFrame getIfContains(DetailAST identToFind, boolean lookForMethod) {
            AbstractFrame frame = !lookForMethod && this.containsFieldOrVariable(identToFind) ? this : this.parent.getIfContains(identToFind, lookForMethod);
            return frame;
        }

        protected boolean containsFieldOrVariableDef(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!this.isProperDefinition(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String identToFind = ident.getText();
            return identToFind.equals(ast.getText()) && CheckUtil.isBeforeInSource(ast, ident);
        }
    }

    private static enum FrameType {
        CLASS_FRAME,
        CTOR_FRAME,
        METHOD_FRAME,
        BLOCK_FRAME,
        CATCH_FRAME,
        FOR_FRAME,
        TRY_WITH_RESOURCES_FRAME;

    }
}

