/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;

public class UncommentedMainCheck
extends Check {
    public static final String MSG_KEY = "uncommented.main";
    private String excludedClasses = "^$";
    private Pattern excludedClassesPattern = CommonUtils.createPattern(this.excludedClasses);
    private String currentClass;
    private FullIdent packageName;
    private int classDepth;

    public void setExcludedClasses(String excludedClasses) {
        this.excludedClasses = excludedClasses;
        this.excludedClassesPattern = CommonUtils.createPattern(excludedClasses);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 14, 16};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 14, 16};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.packageName = FullIdent.createFullIdent(null);
        this.currentClass = null;
        this.classDepth = 0;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14) {
            if (this.classDepth == 1) {
                this.currentClass = null;
            }
            --this.classDepth;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 16: {
                this.visitPackageDef(ast);
                break;
            }
            case 14: {
                this.visitClassDef(ast);
                break;
            }
            case 9: {
                this.visitMethodDef(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ast.toString());
            }
        }
    }

    private void visitPackageDef(DetailAST packageDef) {
        this.packageName = FullIdent.createFullIdent(packageDef.getLastChild().getPreviousSibling());
    }

    private void visitClassDef(DetailAST classDef) {
        if (this.classDepth == 0) {
            DetailAST ident = classDef.findFirstToken(58);
            this.currentClass = this.packageName.getText() + "." + ident.getText();
            ++this.classDepth;
        }
    }

    private void visitMethodDef(DetailAST method) {
        if (this.classDepth != 1) {
            return;
        }
        if (this.checkClassName() && UncommentedMainCheck.checkName(method) && UncommentedMainCheck.checkModifiers(method) && UncommentedMainCheck.checkType(method) && UncommentedMainCheck.checkParams(method)) {
            this.log(method.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private boolean checkClassName() {
        return !this.excludedClassesPattern.matcher(this.currentClass).find();
    }

    private static boolean checkName(DetailAST method) {
        DetailAST ident = method.findFirstToken(58);
        return "main".equals(ident.getText());
    }

    private static boolean checkModifiers(DetailAST method) {
        DetailAST modifiers = method.findFirstToken(5);
        return modifiers.branchContains(62) && modifiers.branchContains(64);
    }

    private static boolean checkType(DetailAST method) {
        DetailAST type = method.findFirstToken(13).getFirstChild();
        return type.getType() == 49;
    }

    private static boolean checkParams(DetailAST method) {
        DetailAST paratype;
        DetailAST arrayDecl;
        boolean checkPassed = false;
        DetailAST params = method.findFirstToken(20);
        if (params.getChildCount() == 1 && (arrayDecl = (paratype = params.getFirstChild().findFirstToken(13)).findFirstToken(17)) != null) {
            DetailAST arrayType = arrayDecl.getFirstChild();
            FullIdent type = FullIdent.createFullIdent(arrayType);
            checkPassed = "String".equals(type.getText()) || "java.lang.String".equals(type.getText());
        }
        return checkPassed;
    }
}

