/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileSetCheck;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.lang3.ArrayUtils;

public abstract class AbstractFileSetCheck
extends AbstractViolationReporter
implements FileSetCheck {
    private MessageDispatcher messageDispatcher;
    private String[] fileExtensions = ArrayUtils.EMPTY_STRING_ARRAY;
    private final LocalizedMessages messageCollector = new LocalizedMessages();

    protected abstract void processFiltered(File var1, List<String> var2) throws CheckstyleException;

    @Override
    public void init() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void beginProcessing(String charset) {
    }

    @Override
    public final SortedSet<LocalizedMessage> process(File file, List<String> lines) throws CheckstyleException {
        this.messageCollector.reset();
        if (CommonUtils.matchesFileExtension(file, this.fileExtensions)) {
            this.processFiltered(file, lines);
        }
        return this.messageCollector.getMessages();
    }

    @Override
    public void finishProcessing() {
    }

    @Override
    public final void setMessageDispatcher(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
    }

    protected final MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public String[] getFileExtensions() {
        return Arrays.copyOf(this.fileExtensions, this.fileExtensions.length);
    }

    public final void setFileExtensions(String ... extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException("Extensions array can not be null");
        }
        this.fileExtensions = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            String extension = extensions[i];
            this.fileExtensions[i] = CommonUtils.startsWithChar(extension, '.') ? extension : "." + extension;
        }
    }

    protected final LocalizedMessages getMessageCollector() {
        return this.messageCollector;
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.log(line, 0, key, args);
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        this.messageCollector.add(new LocalizedMessage(lineNo, colNo, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    protected final void fireErrors(String fileName) {
        SortedSet<LocalizedMessage> errors = this.messageCollector.getMessages();
        this.messageCollector.reset();
        this.getMessageDispatcher().fireErrors(fileName, errors);
    }
}

