/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class HiddenFieldCheck
extends Check {
    public static final String MSG_KEY = "hidden.field";
    private FieldFrame frame;
    private Pattern regexp;
    private boolean ignoreSetter;
    private boolean setterCanReturnItsClass;
    private boolean ignoreConstructorParameter;
    private boolean ignoreAbstractMethods;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21, 14, 154, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 154, 155};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.frame = new FieldFrame(null, true, null);
    }

    @Override
    public void visitToken(DetailAST ast) {
        int type = ast.getType();
        switch (type) {
            case 10: 
            case 21: {
                this.processVariable(ast);
                break;
            }
            default: {
                this.visitOtherTokens(ast, type);
            }
        }
    }

    private void visitOtherTokens(DetailAST ast, int type) {
        DetailAST typeMods = ast.findFirstToken(5);
        boolean isStaticInnerType = typeMods != null && typeMods.branchContains(64);
        String frameName = type == 14 || type == 154 ? ast.findFirstToken(58).getText() : null;
        FieldFrame newFrame = new FieldFrame(this.frame, isStaticInnerType, frameName);
        DetailAST objBlock = ast.findFirstToken(6);
        if (objBlock != null) {
            for (DetailAST child = objBlock.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 10) continue;
                String name = child.findFirstToken(58).getText();
                DetailAST mods = child.findFirstToken(5);
                if (mods.branchContains(64)) {
                    newFrame.addStaticField(name);
                    continue;
                }
                newFrame.addInstanceField(name);
            }
        }
        this.frame = newFrame;
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() == 14 || ast.getType() == 154 || ast.getType() == 155) {
            this.frame = this.frame.getParent();
        }
    }

    private void processVariable(DetailAST ast) {
        DetailAST nameAST;
        String name;
        if (!(ScopeUtils.isInInterfaceOrAnnotationBlock(ast) || !ScopeUtils.isLocalVariableDef(ast) && ast.getType() != 21 || !this.isStaticOrInstanceField(ast, name = (nameAST = ast.findFirstToken(58)).getText()) || this.isMatchingRegexp(name) || this.isIgnoredSetterParam(ast, name) || this.isIgnoredConstructorParam(ast) || this.isIgnoredParamOfAbstractMethod(ast))) {
            this.log(nameAST, MSG_KEY, name);
        }
    }

    private boolean isStaticOrInstanceField(DetailAST ast, String name) {
        return this.frame.containsStaticField(name) || !HiddenFieldCheck.isInStatic(ast) && this.frame.containsInstanceField(name);
    }

    private boolean isMatchingRegexp(String name) {
        return this.regexp != null && this.regexp.matcher(name).find();
    }

    private static boolean isInStatic(DetailAST ast) {
        boolean inStatic = false;
        for (DetailAST parent = ast.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() == 12) {
                inStatic = true;
                break;
            }
            if (parent.getType() != 9) continue;
            DetailAST mods = parent.findFirstToken(5);
            inStatic = mods.branchContains(64);
            break;
        }
        return inStatic;
    }

    private boolean isIgnoredSetterParam(DetailAST ast, String name) {
        if (ast.getType() == 21 && this.ignoreSetter) {
            DetailAST parametersAST = ast.getParent();
            DetailAST methodAST = parametersAST.getParent();
            if (parametersAST.getChildCount() == 1 && methodAST.getType() == 9 && this.isSetterMethod(methodAST, name)) {
                return true;
            }
        }
        return false;
    }

    private boolean isSetterMethod(DetailAST aMethodAST, String aName) {
        String methodName = aMethodAST.findFirstToken(58).getText();
        boolean isSetterMethod = false;
        if (methodName.equals("set" + HiddenFieldCheck.capitalize(aName))) {
            DetailAST typeAST = aMethodAST.findFirstToken(13);
            String returnType = typeAST.getFirstChild().getText();
            if (typeAST.branchContains(49) || this.setterCanReturnItsClass && this.frame.isEmbeddedIn(returnType)) {
                isSetterMethod = true;
            }
        }
        return isSetterMethod;
    }

    private static String capitalize(String name) {
        String setterName = name;
        if (name.length() == 1 || !Character.isUpperCase(name.charAt(1))) {
            setterName = name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
        }
        return setterName;
    }

    private boolean isIgnoredConstructorParam(DetailAST ast) {
        boolean result = false;
        if (ast.getType() == 21 && this.ignoreConstructorParameter) {
            DetailAST parametersAST = ast.getParent();
            DetailAST constructorAST = parametersAST.getParent();
            result = constructorAST.getType() == 8;
        }
        return result;
    }

    private boolean isIgnoredParamOfAbstractMethod(DetailAST ast) {
        DetailAST method;
        boolean result = false;
        if (ast.getType() == 21 && this.ignoreAbstractMethods && (method = ast.getParent().getParent()).getType() == 9) {
            DetailAST mods = method.findFirstToken(5);
            result = mods.branchContains(40);
        }
        return result;
    }

    public void setIgnoreFormat(String format) {
        this.regexp = CommonUtils.createPattern(format);
    }

    public void setIgnoreSetter(boolean ignoreSetter) {
        this.ignoreSetter = ignoreSetter;
    }

    public void setSetterCanReturnItsClass(boolean aSetterCanReturnItsClass) {
        this.setterCanReturnItsClass = aSetterCanReturnItsClass;
    }

    public void setIgnoreConstructorParameter(boolean ignoreConstructorParameter) {
        this.ignoreConstructorParameter = ignoreConstructorParameter;
    }

    public void setIgnoreAbstractMethods(boolean ignoreAbstractMethods) {
        this.ignoreAbstractMethods = ignoreAbstractMethods;
    }

    private static class FieldFrame {
        private final String frameName;
        private final boolean staticType;
        private final FieldFrame parent;
        private final Set<String> instanceFields = Sets.newHashSet();
        private final Set<String> staticFields = Sets.newHashSet();

        FieldFrame(FieldFrame parent, boolean staticType, String frameName) {
            this.parent = parent;
            this.staticType = staticType;
            this.frameName = frameName;
        }

        public void addInstanceField(String field) {
            this.instanceFields.add(field);
        }

        public void addStaticField(String field) {
            this.staticFields.add(field);
        }

        public boolean containsInstanceField(String field) {
            return this.instanceFields.contains(field) || this.parent != null && !this.staticType && this.parent.containsInstanceField(field);
        }

        public boolean containsStaticField(String field) {
            return this.staticFields.contains(field) || this.parent != null && this.parent.containsStaticField(field);
        }

        public FieldFrame getParent() {
            return this.parent;
        }

        private boolean isEmbeddedIn(String classOrEnumName) {
            FieldFrame currentFrame = this;
            while (currentFrame != null) {
                if (Objects.equals(currentFrame.frameName, classOrEnumName)) {
                    return true;
                }
                currentFrame = currentFrame.parent;
            }
            return false;
        }
    }
}

