/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import org.apache.commons.lang3.ArrayUtils;

public class MethodLengthCheck
extends Check {
    public static final String MSG_KEY = "maxLen.method";
    private static final int DEFAULT_MAX_LINES = 150;
    private boolean countEmpty = true;
    private int max = 150;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9, 8};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST openingBrace = ast.findFirstToken(7);
        if (openingBrace != null) {
            DetailAST closingBrace = openingBrace.findFirstToken(73);
            int length = closingBrace.getLineNo() - openingBrace.getLineNo() + 1;
            if (!this.countEmpty) {
                FileContents contents = this.getFileContents();
                int lastLine = closingBrace.getLineNo();
                for (int i = openingBrace.getLineNo() - 1; i < lastLine; ++i) {
                    if (!contents.lineIsBlank(i) && !contents.lineIsComment(i)) continue;
                    --length;
                }
            }
            if (length > this.max) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, length, this.max);
            }
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public void setCountEmpty(boolean countEmpty) {
        this.countEmpty = countEmpty;
    }
}

