/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.TreeTableModel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;

public class TreeTableModelAdapter
extends AbstractTableModel {
    private static final long serialVersionUID = 8269213416115369275L;
    private final JTree tree;
    private final transient TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new UpdatingTreeExpansionListener());
        treeTableModel.addTreeModelListener(new UpdatingTreeModelListener());
    }

    @Override
    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    @Override
    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    @Override
    public int getRowCount() {
        return this.tree.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(column);
    }

    private Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        return treePath.getLastPathComponent();
    }

    private void delayedFireTableDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
    }

    private class UpdatingTreeModelListener
    implements TreeModelListener {
        private UpdatingTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreeTableModelAdapter.this.delayedFireTableDataChanged();
        }
    }

    private class UpdatingTreeExpansionListener
    implements TreeExpansionListener {
        private UpdatingTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            TreeTableModelAdapter.this.fireTableDataChanged();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            TreeTableModelAdapter.this.fireTableDataChanged();
        }
    }
}

