/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class BlockParentHandler
extends AbstractExpressionHandler {
    private static final int[] CHECKED_CHILDREN = new int[]{10, 28, 6, 86, 88, 90, 87};

    public BlockParentHandler(IndentationCheck indentCheck, String name, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, name, ast, parent);
    }

    protected int[] getCheckedChildren() {
        return (int[])CHECKED_CHILDREN.clone();
    }

    protected DetailAST getTopLevelAst() {
        return this.getMainAst();
    }

    protected void checkTopLevelToken() {
        DetailAST topLevel = this.getTopLevelAst();
        if (topLevel == null || this.getLevel().isAcceptable(this.expandedTabsColumnNo(topLevel)) || this.hasLabelBefore()) {
            return;
        }
        if (!this.shouldTopLevelStartLine() && !this.startsLine(topLevel)) {
            return;
        }
        this.logError(topLevel, "", this.expandedTabsColumnNo(topLevel));
    }

    protected boolean hasLabelBefore() {
        DetailAST parent = this.getTopLevelAst().getParent();
        return parent.getType() == 22 && parent.getLineNo() == this.getTopLevelAst().getLineNo();
    }

    protected boolean shouldTopLevelStartLine() {
        return true;
    }

    protected boolean hasCurlies() {
        return this.getLCurly() != null && this.getRCurly() != null;
    }

    protected DetailAST getLCurly() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRCurly() {
        DetailAST slist = this.getMainAst().findFirstToken(7);
        return slist.findFirstToken(73);
    }

    protected void checkLCurly() {
        DetailAST lcurly = this.getLCurly();
        int lcurlyPos = this.expandedTabsColumnNo(lcurly);
        if (this.curlyLevel().isAcceptable(lcurlyPos) || !this.startsLine(lcurly)) {
            return;
        }
        this.logError(lcurly, "lcurly", lcurlyPos);
    }

    protected IndentLevel curlyLevel() {
        return new IndentLevel(this.getLevel(), this.getBraceAdjustment());
    }

    protected boolean shouldStartWithRCurly() {
        return true;
    }

    protected boolean canChildrenBeNested() {
        return false;
    }

    protected void checkRCurly() {
        DetailAST lcurly = this.getLCurly();
        DetailAST rcurly = this.getRCurly();
        int rcurlyPos = this.expandedTabsColumnNo(rcurly);
        if (this.curlyLevel().isAcceptable(rcurlyPos) || !this.shouldStartWithRCurly() && !this.startsLine(rcurly) || BlockParentHandler.areOnSameLine(rcurly, lcurly)) {
            return;
        }
        this.logError(rcurly, "rcurly", rcurlyPos, this.curlyLevel());
    }

    protected DetailAST getNonListChild() {
        return this.getMainAst().findFirstToken(77).getNextSibling();
    }

    private void checkNonListChild() {
        DetailAST nonList = this.getNonListChild();
        if (nonList == null) {
            return;
        }
        IndentLevel expected = new IndentLevel(this.getLevel(), this.getBasicOffset());
        this.checkExpressionSubtree(nonList, expected, false, false);
    }

    protected DetailAST getListChild() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRParen() {
        return this.getMainAst().findFirstToken(77);
    }

    protected DetailAST getLParen() {
        return this.getMainAst().findFirstToken(76);
    }

    @Override
    public void checkIndentation() {
        DetailAST listChild;
        this.checkTopLevelToken();
        this.checkLParen(this.getLParen());
        this.checkRParen(this.getLParen(), this.getRParen());
        if (this.hasCurlies()) {
            this.checkLCurly();
            this.checkRCurly();
        }
        if ((listChild = this.getListChild()) == null) {
            this.checkNonListChild();
        } else if (!this.hasCurlies() || !BlockParentHandler.areOnSameLine(this.getLCurly(), this.getRCurly())) {
            this.checkChildren(listChild, this.getCheckedChildren(), this.getChildrenExpectedLevel(), true, this.canChildrenBeNested());
        }
    }

    protected IndentLevel getChildrenExpectedLevel() {
        IndentLevel indentLevel = new IndentLevel(this.getLevel(), this.getBasicOffset());
        if (this.getLevel().isMultiLevel() && this.hasCurlies()) {
            if (this.startsLine(this.getLCurly())) {
                indentLevel = new IndentLevel(this.expandedTabsColumnNo(this.getLCurly()) + this.getBasicOffset());
            } else if (this.startsLine(this.getRCurly())) {
                IndentLevel level = new IndentLevel(this.curlyLevel(), this.getBasicOffset());
                level.addAcceptedIndent(level.getFirstIndentLevel() + this.getLineWrappingIndent());
                indentLevel = level;
            }
        }
        return indentLevel;
    }

    @Override
    public IndentLevel suggestedChildLevel(AbstractExpressionHandler child) {
        return this.getChildrenExpectedLevel();
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }
}

