/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.Listener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

class FileDrop {
    private static final Color DEFAULT_BORDER_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.25f);
    private Border normalBorder;
    private final DropTargetListener dropListener;

    FileDrop(Component component, Listener listener) throws TooManyListenersException {
        this(component, BorderFactory.createMatteBorder(2, 2, 2, 2, DEFAULT_BORDER_COLOR), true, listener);
    }

    private FileDrop(Component component, Border dragBorder, boolean recursive, Listener listener) throws TooManyListenersException {
        this.dropListener = new FileDropTargetListener(component, dragBorder, listener);
        this.makeDropTarget(component, recursive);
    }

    private void makeDropTarget(final Component component, boolean recursive) throws TooManyListenersException {
        DropTarget target = new DropTarget();
        target.addDropTargetListener(this.dropListener);
        component.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                Container parent = component.getParent();
                if (parent == null) {
                    component.setDropTarget(null);
                } else {
                    new DropTarget(component, FileDrop.this.dropListener);
                }
            }
        });
        if (component.getParent() != null) {
            new DropTarget(component, this.dropListener);
        }
        if (recursive && component instanceof Container) {
            Component[] comps;
            Container cont = (Container)component;
            for (Component element : comps = cont.getComponents()) {
                this.makeDropTarget(element, recursive);
            }
        }
    }

    private static boolean isDragOk(DropTargetDragEvent event) {
        boolean okStatus = false;
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        for (int index = 0; !okStatus && index < flavors.length; ++index) {
            if (!flavors[index].equals(DataFlavor.javaFileListFlavor)) continue;
            okStatus = true;
        }
        return okStatus;
    }

    private class FileDropTargetListener
    extends DropTargetAdapter {
        private final Component component;
        private final Border dragBorder;
        private final Listener listener;

        FileDropTargetListener(Component component, Border dragBorder, Listener listener) {
            this.component = component;
            this.dragBorder = dragBorder;
            this.listener = listener;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (FileDrop.isDragOk(event)) {
                if (this.component instanceof JComponent) {
                    JComponent comp = (JComponent)this.component;
                    FileDrop.this.normalBorder = comp.getBorder();
                    comp.setBorder(this.dragBorder);
                }
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                Transferable transferable = event.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    event.acceptDrop(1);
                    List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                    File[] files = new File[fileList.size()];
                    fileList.toArray(files);
                    if (this.listener != null) {
                        this.listener.filesDropped(files);
                    }
                    event.getDropTargetContext().dropComplete(true);
                } else {
                    event.rejectDrop();
                }
            }
            catch (UnsupportedFlavorException | IOException ignored) {
                event.rejectDrop();
            }
            finally {
                if (this.component instanceof JComponent) {
                    JComponent comp = (JComponent)this.component;
                    comp.setBorder(FileDrop.this.normalBorder);
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (this.component instanceof JComponent) {
                JComponent comp = (JComponent)this.component;
                comp.setBorder(FileDrop.this.normalBorder);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (FileDrop.isDragOk(event)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }
    }
}

