/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.blocks.LeftCurlyOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.ArrayUtils;

public class LeftCurlyCheck
extends Check {
    public static final String MSG_KEY_LINE_NEW = "line.new";
    public static final String MSG_KEY_LINE_PREVIOUS = "line.previous";
    public static final String MSG_KEY_LINE_BREAK_AFTER = "line.break.after";
    private static final String OPEN_CURLY_BRACE = "{";
    private boolean ignoreEnums = true;
    private LeftCurlyOption option = LeftCurlyOption.EOL;

    public void setOption(String optionStr) {
        try {
            this.option = LeftCurlyOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, (Throwable)iae);
        }
    }

    @Deprecated
    public void setMaxLineLength(int maxLineLength) {
    }

    public void setIgnoreEnums(boolean ignoreEnums) {
        this.ignoreEnums = ignoreEnums;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{15, 14, 157, 154, 8, 9, 155, 84, 95, 96, 97, 67, 89, 85, 83, 92, 91, 12, 6};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST brace;
        DetailAST startToken;
        switch (ast.getType()) {
            case 8: 
            case 9: {
                startToken = LeftCurlyCheck.skipAnnotationOnlyLines(ast);
                brace = ast.findFirstToken(7);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 155: 
            case 157: {
                DetailAST objBlock;
                startToken = LeftCurlyCheck.skipAnnotationOnlyLines(ast);
                brace = objBlock = ast.findFirstToken(6);
                if (objBlock == null) break;
                brace = objBlock.getFirstChild();
                break;
            }
            case 12: 
            case 67: 
            case 83: 
            case 84: 
            case 85: 
            case 91: 
            case 95: 
            case 96: 
            case 97: {
                startToken = ast;
                brace = ast.findFirstToken(7);
                break;
            }
            case 92: {
                startToken = ast;
                DetailAST candidate = ast.getFirstChild();
                brace = null;
                if (candidate.getType() != 7) break;
                brace = candidate;
                break;
            }
            default: {
                startToken = ast;
                brace = ast.findFirstToken(72);
            }
        }
        if (brace != null) {
            this.verifyBrace(brace, startToken);
        }
    }

    private static DetailAST skipAnnotationOnlyLines(DetailAST ast) {
        DetailAST lastAnnotation;
        DetailAST resultNode = ast;
        DetailAST modifiers = ast.findFirstToken(5);
        if (modifiers != null && (lastAnnotation = LeftCurlyCheck.findLastAnnotation(modifiers)) != null) {
            DetailAST tokenAfterLast = lastAnnotation.getNextSibling() == null ? modifiers.getNextSibling() : lastAnnotation.getNextSibling();
            resultNode = tokenAfterLast.getLineNo() > lastAnnotation.getLineNo() ? tokenAfterLast : LeftCurlyCheck.getFirstAnnotationOnSameLine(lastAnnotation);
        }
        return resultNode;
    }

    private static DetailAST getFirstAnnotationOnSameLine(DetailAST annotation) {
        DetailAST previousAnnotation = annotation;
        int lastAnnotationLineNumber = previousAnnotation.getLineNo();
        while (previousAnnotation.getPreviousSibling() != null && previousAnnotation.getPreviousSibling().getLineNo() == lastAnnotationLineNumber) {
            previousAnnotation = previousAnnotation.getPreviousSibling();
        }
        return previousAnnotation;
    }

    private static DetailAST findLastAnnotation(DetailAST modifiers) {
        DetailAST annotation;
        for (annotation = modifiers.findFirstToken(159); annotation != null && annotation.getNextSibling() != null && annotation.getNextSibling().getType() == 159; annotation = annotation.getNextSibling()) {
        }
        return annotation;
    }

    private void verifyBrace(DetailAST brace, DetailAST startToken) {
        String braceLine = this.getLine(brace.getLineNo() - 1);
        if (braceLine.length() <= brace.getColumnNo() + 1 || braceLine.charAt(brace.getColumnNo() + 1) != '}') {
            if (this.option == LeftCurlyOption.NL) {
                if (!CommonUtils.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
                    this.log(brace, MSG_KEY_LINE_NEW, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
                }
            } else if (this.option == LeftCurlyOption.EOL) {
                this.validateEol(brace, braceLine);
            } else if (startToken.getLineNo() != brace.getLineNo()) {
                this.validateNewLinePosition(brace, startToken, braceLine);
            }
        }
    }

    private void validateEol(DetailAST brace, String braceLine) {
        if (CommonUtils.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
            this.log(brace, MSG_KEY_LINE_PREVIOUS, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
        }
        if (!this.hasLineBreakAfter(brace)) {
            this.log(brace, MSG_KEY_LINE_BREAK_AFTER, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
        }
    }

    private void validateNewLinePosition(DetailAST brace, DetailAST startToken, String braceLine) {
        if (startToken.getLineNo() + 1 == brace.getLineNo()) {
            if (CommonUtils.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
                this.log(brace, MSG_KEY_LINE_PREVIOUS, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
            } else {
                this.log(brace, MSG_KEY_LINE_NEW, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
            }
        } else if (!CommonUtils.hasWhitespaceBefore(brace.getColumnNo(), braceLine)) {
            this.log(brace, MSG_KEY_LINE_NEW, OPEN_CURLY_BRACE, brace.getColumnNo() + 1);
        }
    }

    private boolean hasLineBreakAfter(DetailAST leftCurly) {
        DetailAST nextToken = null;
        if (leftCurly.getType() == 7) {
            nextToken = leftCurly.getFirstChild();
        } else if (leftCurly.getParent().getParent().getType() == 154 && !this.ignoreEnums) {
            nextToken = leftCurly.getNextSibling();
        }
        return nextToken == null || nextToken.getType() == 73 || leftCurly.getLineNo() != nextToken.getLineNo();
    }
}

