/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import antlr.ASTFactory;
import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ParseTreeTableModel
implements TreeModel {
    private static final String[] COLUMN_NAMES = new String[]{"Tree", "Type", "Line", "Column", "Text"};
    private final Object root;
    private final EventListenerList listenerList = new EventListenerList();

    public ParseTreeTableModel(DetailAST parseTree) {
        this.root = ParseTreeTableModel.createArtificialTreeRoot();
        this.setParseTree(parseTree);
    }

    private static DetailAST createArtificialTreeRoot() {
        ASTFactory factory = new ASTFactory();
        factory.setASTNodeClass(DetailAST.class.getName());
        return (DetailAST)factory.create(1, "ROOT");
    }

    final void setParseTree(DetailAST parseTree) {
        ((AST)this.root).setFirstChild((AST)parseTree);
        Object[] path = new Object[]{this.root};
        this.fireTreeStructureChanged(this, path, null, null);
    }

    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public Class<?> getColumnClass(int column) {
        Class columnClass;
        switch (column) {
            case 0: {
                columnClass = ParseTreeTableModel.class;
                break;
            }
            case 1: {
                columnClass = String.class;
                break;
            }
            case 2: {
                columnClass = Integer.class;
                break;
            }
            case 3: {
                columnClass = Integer.class;
                break;
            }
            case 4: {
                columnClass = String.class;
                break;
            }
            default: {
                columnClass = Object.class;
            }
        }
        return columnClass;
    }

    public Object getValueAt(Object node, int column) {
        Object value;
        DetailAST ast = (DetailAST)((Object)node);
        switch (column) {
            case 1: {
                value = TokenUtils.getTokenName(ast.getType());
                break;
            }
            case 2: {
                value = ast.getLineNo();
                break;
            }
            case 3: {
                value = ast.getColumnNo();
                break;
            }
            case 4: {
                value = ast.getText();
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    @Override
    public Object getChild(Object parent, int index) {
        DetailAST ast = (DetailAST)((Object)parent);
        DetailAST child = ast.getFirstChild();
        for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
            child = child.getNextSibling();
        }
        return child;
    }

    @Override
    public int getChildCount(Object parent) {
        DetailAST ast = (DetailAST)((Object)parent);
        return ast.getChildCount();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (!this.getChild(parent, i).equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listenerList.add(TreeModelListener.class, listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listenerList.remove(TreeModelListener.class, listener);
    }

    final void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object ... children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    public boolean isCellEditable(int column) {
        return this.getColumnClass(column) == ParseTreeTableModel.class;
    }
}

