/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.PadOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public abstract class AbstractParenPadCheck
extends Check {
    public static final String MSG_WS_FOLLOWED = "ws.followed";
    public static final String MSG_WS_NOT_FOLLOWED = "ws.notFollowed";
    public static final String MSG_WS_PRECEDED = "ws.preceded";
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    private static final char OPEN_PARENTHESIS = '(';
    private static final char CLOSE_PARENTHESIS = ')';
    private PadOption option = PadOption.NOSPACE;

    public void setOption(String optionStr) {
        try {
            this.option = PadOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, (Throwable)iae);
        }
    }

    protected void processLeft(DetailAST ast) {
        String line = this.getLines()[ast.getLineNo() - 1];
        int after = ast.getColumnNo() + 1;
        if (after < line.length()) {
            if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(after))) {
                this.log(ast.getLineNo(), after, MSG_WS_FOLLOWED, Character.valueOf('('));
            } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(after)) && line.charAt(after) != ')') {
                this.log(ast.getLineNo(), after, MSG_WS_NOT_FOLLOWED, Character.valueOf('('));
            }
        }
    }

    protected void processRight(DetailAST ast) {
        String line = this.getLines()[ast.getLineNo() - 1];
        int before = ast.getColumnNo() - 1;
        if (before >= 0) {
            if (this.option == PadOption.NOSPACE && Character.isWhitespace(line.charAt(before)) && !CommonUtils.hasWhitespaceBefore(before, line)) {
                this.log(ast.getLineNo(), before, MSG_WS_PRECEDED, Character.valueOf(')'));
            } else if (this.option == PadOption.SPACE && !Character.isWhitespace(line.charAt(before)) && line.charAt(before) != '(') {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_WS_NOT_PRECEDED, Character.valueOf(')'));
            }
        }
    }
}

