/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public final class AnnotationUseStyleCheck
extends AbstractCheck {
    public static final String MSG_KEY_ANNOTATION_INCORRECT_STYLE = "annotation.incorrect.style";
    public static final String MSG_KEY_ANNOTATION_PARENS_MISSING = "annotation.parens.missing";
    public static final String MSG_KEY_ANNOTATION_PARENS_PRESENT = "annotation.parens.present";
    public static final String MSG_KEY_ANNOTATION_TRAILING_COMMA_MISSING = "annotation.trailing.comma.missing";
    public static final String MSG_KEY_ANNOTATION_TRAILING_COMMA_PRESENT = "annotation.trailing.comma.present";
    private static final String ANNOTATION_ELEMENT_SINGLE_NAME = "value";
    private ElementStyle elementStyle = ElementStyle.COMPACT_NO_ARRAY;
    private TrailingArrayComma trailingArrayComma = TrailingArrayComma.NEVER;
    private ClosingParens closingParens = ClosingParens.NEVER;

    public void setElementStyle(String style) {
        this.elementStyle = AnnotationUseStyleCheck.getOption(ElementStyle.class, style);
    }

    public void setTrailingArrayComma(String comma) {
        this.trailingArrayComma = AnnotationUseStyleCheck.getOption(TrailingArrayComma.class, comma);
    }

    public void setClosingParens(String parens) {
        this.closingParens = AnnotationUseStyleCheck.getOption(ClosingParens.class, parens);
    }

    private static <T extends Enum<T>> T getOption(Class<T> enumClass, String value) {
        try {
            return Enum.valueOf(enumClass, value.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + value, (Throwable)iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{158};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.checkStyleType(ast);
        this.checkCheckClosingParens(ast);
        this.checkTrailingComma(ast);
    }

    private void checkStyleType(DetailAST annotation) {
        switch (this.elementStyle) {
            case COMPACT_NO_ARRAY: {
                this.checkCompactNoArrayStyle(annotation);
                break;
            }
            case COMPACT: {
                this.checkCompactStyle(annotation);
                break;
            }
            case EXPANDED: {
                this.checkExpandedStyle(annotation);
                break;
            }
        }
    }

    private void checkExpandedStyle(DetailAST annotation) {
        int valuePairCount = annotation.getChildCount(159);
        if (valuePairCount == 0 && annotation.branchContains(28)) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.EXPANDED});
        }
    }

    private void checkCompactStyle(DetailAST annotation) {
        int valuePairCount = annotation.getChildCount(159);
        DetailAST valuePair = annotation.findFirstToken(159);
        if (valuePairCount == 1 && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText())) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.COMPACT});
        }
    }

    private void checkCompactNoArrayStyle(DetailAST annotation) {
        DetailAST nestedArrayInit;
        DetailAST arrayInit = annotation.findFirstToken(161);
        int valuePairCount = annotation.getChildCount(159);
        DetailAST valuePair = annotation.findFirstToken(159);
        if (arrayInit != null && arrayInit.getChildCount(28) == 1) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.COMPACT_NO_ARRAY});
        } else if (valuePairCount == 1 && (nestedArrayInit = valuePair.findFirstToken(161)) != null && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText()) && nestedArrayInit.getChildCount(28) == 1) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.COMPACT_NO_ARRAY});
        }
    }

    private void checkTrailingComma(DetailAST annotation) {
        if (this.trailingArrayComma == TrailingArrayComma.IGNORE) {
            return;
        }
        for (DetailAST child = annotation.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST arrayInit = null;
            if (child.getType() == 159) {
                arrayInit = child.findFirstToken(161);
            } else if (child.getType() == 161) {
                arrayInit = child;
            }
            if (arrayInit == null) continue;
            this.logCommaViolation(arrayInit);
        }
    }

    private void logCommaViolation(DetailAST ast) {
        DetailAST rCurly = ast.findFirstToken(73);
        DetailAST comma = rCurly.getPreviousSibling();
        if (this.trailingArrayComma == TrailingArrayComma.ALWAYS && (comma == null || comma.getType() != 74)) {
            this.log(rCurly.getLineNo(), rCurly.getColumnNo(), MSG_KEY_ANNOTATION_TRAILING_COMMA_MISSING, new Object[0]);
        } else if (this.trailingArrayComma == TrailingArrayComma.NEVER && comma != null && comma.getType() == 74) {
            this.log(comma.getLineNo(), comma.getColumnNo(), MSG_KEY_ANNOTATION_TRAILING_COMMA_PRESENT, new Object[0]);
        }
    }

    private void checkCheckClosingParens(DetailAST ast) {
        boolean parenExists;
        if (this.closingParens == ClosingParens.IGNORE) {
            return;
        }
        DetailAST paren = ast.getLastChild();
        boolean bl = parenExists = paren.getType() == 77;
        if (this.closingParens == ClosingParens.ALWAYS && !parenExists) {
            this.log(ast.getLineNo(), MSG_KEY_ANNOTATION_PARENS_MISSING, new Object[0]);
        } else if (this.closingParens == ClosingParens.NEVER && parenExists && !ast.branchContains(28) && !ast.branchContains(159) && !ast.branchContains(161)) {
            this.log(ast.getLineNo(), MSG_KEY_ANNOTATION_PARENS_PRESENT, new Object[0]);
        }
    }

    public static enum ClosingParens {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    public static enum TrailingArrayComma {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    public static enum ElementStyle {
        EXPANDED,
        COMPACT,
        COMPACT_NO_ARRAY,
        IGNORE;

    }
}

