/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;

public class BlockParentHandler
extends AbstractExpressionHandler {
    private static final int[] CHECKED_CHILDREN = new int[]{10, 28, 6, 86, 88, 90, 87};

    public BlockParentHandler(IndentationCheck indentCheck, String name, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, name, ast, parent);
    }

    protected int[] getCheckedChildren() {
        return (int[])CHECKED_CHILDREN.clone();
    }

    protected DetailAST getTopLevelAst() {
        return this.getMainAst();
    }

    protected void checkTopLevelToken() {
        DetailAST topLevel = this.getTopLevelAst();
        if (topLevel != null && !this.getIndent().isAcceptable(this.expandedTabsColumnNo(topLevel)) && !this.hasLabelBefore() && (this.shouldTopLevelStartLine() || this.isOnStartOfLine(topLevel))) {
            this.logError(topLevel, "", this.expandedTabsColumnNo(topLevel));
        }
    }

    protected boolean hasLabelBefore() {
        DetailAST parent = this.getTopLevelAst().getParent();
        return parent.getType() == 22 && parent.getLineNo() == this.getTopLevelAst().getLineNo();
    }

    protected boolean shouldTopLevelStartLine() {
        return true;
    }

    protected boolean hasCurlies() {
        return this.getLCurly() != null && this.getRCurly() != null;
    }

    protected DetailAST getLCurly() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRCurly() {
        DetailAST slist = this.getMainAst().findFirstToken(7);
        return slist.findFirstToken(73);
    }

    protected void checkLCurly() {
        DetailAST lcurly = this.getLCurly();
        int lcurlyPos = this.expandedTabsColumnNo(lcurly);
        if (!this.curlyIndent().isAcceptable(lcurlyPos) && this.isOnStartOfLine(lcurly)) {
            this.logError(lcurly, "lcurly", lcurlyPos, this.curlyIndent());
        }
    }

    protected IndentLevel curlyIndent() {
        return new IndentLevel(this.getIndent(), this.getBraceAdjustment());
    }

    protected boolean shouldStartWithRCurly() {
        return true;
    }

    protected boolean canChildrenBeNested() {
        return false;
    }

    protected void checkRCurly() {
        DetailAST lcurly = this.getLCurly();
        DetailAST rcurly = this.getRCurly();
        int rcurlyPos = this.expandedTabsColumnNo(rcurly);
        if (!this.curlyIndent().isAcceptable(rcurlyPos) && (this.shouldStartWithRCurly() || this.isOnStartOfLine(rcurly)) && !BlockParentHandler.areOnSameLine(rcurly, lcurly)) {
            this.logError(rcurly, "rcurly", rcurlyPos, this.curlyIndent());
        }
    }

    protected DetailAST getNonListChild() {
        return this.getMainAst().findFirstToken(77).getNextSibling();
    }

    private void checkNonListChild() {
        DetailAST nonList = this.getNonListChild();
        if (nonList != null) {
            IndentLevel expected = new IndentLevel(this.getIndent(), this.getBasicOffset());
            this.checkExpressionSubtree(nonList, expected, false, false);
        }
    }

    protected DetailAST getListChild() {
        return this.getMainAst().findFirstToken(7);
    }

    protected DetailAST getRParen() {
        return this.getMainAst().findFirstToken(77);
    }

    protected DetailAST getLParen() {
        return this.getMainAst().findFirstToken(76);
    }

    @Override
    public void checkIndentation() {
        DetailAST listChild;
        this.checkTopLevelToken();
        this.checkLParen(this.getLParen());
        this.checkRParen(this.getLParen(), this.getRParen());
        if (this.hasCurlies()) {
            this.checkLCurly();
            this.checkRCurly();
        }
        if ((listChild = this.getListChild()) == null) {
            this.checkNonListChild();
        } else if (!this.hasCurlies() || !BlockParentHandler.areOnSameLine(this.getLCurly(), this.getRCurly())) {
            this.checkChildren(listChild, this.getCheckedChildren(), this.getChildrenExpectedIndent(), true, this.canChildrenBeNested());
        }
    }

    protected IndentLevel getChildrenExpectedIndent() {
        IndentLevel indentLevel = new IndentLevel(this.getIndent(), this.getBasicOffset());
        if (this.getIndent().isMultiLevel() && this.hasCurlies()) {
            if (this.isOnStartOfLine(this.getLCurly())) {
                indentLevel = new IndentLevel(this.expandedTabsColumnNo(this.getLCurly()) + this.getBasicOffset());
            } else if (this.isOnStartOfLine(this.getRCurly())) {
                IndentLevel level = new IndentLevel(this.curlyIndent(), this.getBasicOffset());
                level.addAcceptedIndent(level.getFirstIndentLevel() + this.getLineWrappingIndent());
                indentLevel = level;
            }
        }
        return indentLevel;
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        return this.getChildrenExpectedIndent();
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }
}

