/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.filters.CSVFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressElement
implements Filter {
    private static final int HASH_MULT = 29;
    private final Pattern fileRegexp;
    private final String filePattern;
    private Pattern checkRegexp;
    private String checkPattern;
    private String moduleId;
    private CSVFilter lineFilter;
    private String linesCSV;
    private CSVFilter columnFilter;
    private String columnsCSV;

    public SuppressElement(String files) throws PatternSyntaxException {
        this.filePattern = files;
        this.fileRegexp = Utils.getPattern(files);
    }

    public void setChecks(String checks) {
        this.checkPattern = checks;
        this.checkRegexp = Utils.getPattern(checks);
    }

    public void setModuleId(String moduleId) {
        this.moduleId = moduleId;
    }

    public void setLines(String lines) {
        this.linesCSV = lines;
        this.lineFilter = lines != null ? new CSVFilter(lines) : null;
    }

    public void setColumns(String columns) {
        this.columnsCSV = columns;
        this.columnFilter = columns != null ? new CSVFilter(columns) : null;
    }

    @Override
    public boolean accept(AuditEvent event) {
        if (event.getFileName() == null || !this.fileRegexp.matcher(event.getFileName()).find() || event.getLocalizedMessage() == null || this.moduleId != null && !this.moduleId.equals(event.getModuleId()) || this.checkRegexp != null && !this.checkRegexp.matcher(event.getSourceName()).find()) {
            return true;
        }
        if (this.lineFilter == null && this.columnFilter == null) {
            return false;
        }
        if (this.lineFilter != null && this.lineFilter.accept(event.getLine())) {
            return false;
        }
        return this.columnFilter == null || !this.columnFilter.accept(event.getColumn());
    }

    public String toString() {
        return "SuppressElement[files=" + this.filePattern + ",checks=" + this.checkPattern + ",lines=" + this.linesCSV + ",columns=" + this.columnsCSV + "]";
    }

    public int hashCode() {
        int result = 29 * this.filePattern.hashCode();
        if (this.checkPattern != null) {
            result = 29 * result + this.checkPattern.hashCode();
        }
        if (this.moduleId != null) {
            result = 29 * result + this.moduleId.hashCode();
        }
        if (this.linesCSV != null) {
            result = 29 * result + this.linesCSV.hashCode();
        }
        if (this.columnsCSV != null) {
            result = 29 * result + this.columnsCSV.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (object instanceof SuppressElement) {
            SuppressElement other = (SuppressElement)object;
            if (!this.filePattern.equals(other.filePattern)) {
                return false;
            }
            if (this.checkPattern != null ? !this.checkPattern.equals(other.checkPattern) : other.checkPattern != null) {
                return false;
            }
            if (this.moduleId != null ? !this.moduleId.equals(other.moduleId) : other.moduleId != null) {
                return false;
            }
            if (this.lineFilter != null ? !this.lineFilter.equals(other.lineFilter) : other.lineFilter != null) {
                return false;
            }
            return !(this.columnFilter != null ? !this.columnFilter.equals(other.columnFilter) : other.columnFilter != null);
        }
        return false;
    }
}

