/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.imports.AccessResult;
import com.puppycrawl.tools.checkstyle.checks.imports.ImportControlLoader;
import com.puppycrawl.tools.checkstyle.checks.imports.PkgControl;
import java.io.File;
import java.net.URI;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.lang3.StringUtils;

public class ImportControlCheck
extends Check {
    public static final String MSG_MISSING_FILE = "import.control.missing.file";
    public static final String MSG_UNKNOWN_PKG = "import.control.unknown.pkg";
    public static final String MSG_DISALLOWED = "import.control.disallowed";
    private PkgControl root;
    private String inPkg;
    private PkgControl currentLeaf;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{16, 30, 152};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{16, 30, 152};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.currentLeaf = null;
    }

    @Override
    public void visitToken(DetailAST ast) {
        FullIdent imp;
        AccessResult access;
        if (ast.getType() == 16) {
            DetailAST nameAST = ast.getLastChild().getPreviousSibling();
            FullIdent full = FullIdent.createFullIdent(nameAST);
            if (this.root == null) {
                this.log(nameAST, MSG_MISSING_FILE, new Object[0]);
            } else {
                this.inPkg = full.getText();
                this.currentLeaf = this.root.locateFinest(this.inPkg);
                if (this.currentLeaf == null) {
                    this.log(nameAST, MSG_UNKNOWN_PKG, new Object[0]);
                }
            }
        } else if (this.currentLeaf != null && AccessResult.ALLOWED != (access = this.currentLeaf.checkAccess((imp = ast.getType() == 30 ? FullIdent.createFullIdentBelow(ast) : FullIdent.createFullIdent(ast.getFirstChild().getNextSibling())).getText(), this.inPkg))) {
            this.log(ast, MSG_DISALLOWED, imp.getText());
        }
    }

    public void setUrl(String url) {
        URI uri;
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        try {
            uri = URI.create(url);
        }
        catch (IllegalArgumentException ex) {
            throw new ConversionException("syntax error in url " + url, (Throwable)ex);
        }
        try {
            this.root = ImportControlLoader.load(uri);
        }
        catch (CheckstyleException ex) {
            throw new ConversionException("Unable to load " + url, (Throwable)ex);
        }
    }

    public void setFile(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        try {
            this.root = ImportControlLoader.load(new File(name).toURI());
        }
        catch (CheckstyleException ex) {
            throw new ConversionException("Unable to load " + name, (Throwable)ex);
        }
    }
}

