/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.regex.Pattern;

public class LocalVariableNameCheck
extends AbstractNameCheck {
    private static final Pattern SINGLE_CHAR = Pattern.compile("^[a-z]$");
    private boolean allowOneCharVarInForLoop;

    public LocalVariableNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public final void setAllowOneCharVarInForLoop(boolean allow) {
        this.allowOneCharVarInForLoop = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        boolean result;
        if (this.allowOneCharVarInForLoop && LocalVariableNameCheck.isForLoopVariable(ast)) {
            String variableName = ast.findFirstToken(58).getText();
            result = !SINGLE_CHAR.matcher(variableName).find();
        } else {
            DetailAST modifiersAST = ast.findFirstToken(5);
            boolean isFinal = modifiersAST.findFirstToken(39) != null;
            result = !isFinal && ScopeUtils.isLocalVariableDef(ast);
        }
        return result;
    }

    private static boolean isForLoopVariable(DetailAST variableDef) {
        int parentType = variableDef.getParent().getType();
        return parentType == 35 || parentType == 156;
    }
}

