/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class TokenUtils {
    private static final Map<String, Integer> TOKEN_NAME_TO_VALUE = TokenUtils.nameToValueMapFromPublicIntFields(TokenTypes.class);
    private static final String[] TOKEN_VALUE_TO_NAME = TokenUtils.valueToNameArrayFromNameToValueMap(TOKEN_NAME_TO_VALUE);
    private static final int[] TOKEN_IDS = TOKEN_NAME_TO_VALUE.values().stream().mapToInt(Integer::intValue).toArray();
    private static final String TOKEN_ID_EXCEPTION_PREFIX = "given id ";
    private static final String TOKEN_NAME_EXCEPTION_PREFIX = "given name ";

    private TokenUtils() {
    }

    public static int getIntFromField(Field field, Object object) {
        try {
            return field.getInt(object);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static Map<String, Integer> nameToValueMapFromPublicIntFields(Class<?> cls) {
        Map<String, Integer> map = Arrays.stream(cls.getDeclaredFields()).filter(fld -> Modifier.isPublic(fld.getModifiers()) && fld.getType() == Integer.TYPE).collect(Collectors.toMap(Field::getName, fld -> TokenUtils.getIntFromField(fld, fld.getName())));
        return Collections.unmodifiableMap(map);
    }

    public static String[] valueToNameArrayFromNameToValueMap(Map<String, Integer> map) {
        String[] valueToNameArray = CommonUtils.EMPTY_STRING_ARRAY;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int value = entry.getValue();
            if (value < 0) continue;
            if (value >= valueToNameArray.length) {
                String[] temp = new String[value + 1];
                System.arraycopy(valueToNameArray, 0, temp, 0, valueToNameArray.length);
                valueToNameArray = temp;
            }
            valueToNameArray[value] = entry.getKey();
        }
        return valueToNameArray;
    }

    public static int getTokenTypesTotalNumber() {
        return TOKEN_IDS.length;
    }

    public static int[] getAllTokenIds() {
        int[] safeCopy = new int[TOKEN_IDS.length];
        System.arraycopy(TOKEN_IDS, 0, safeCopy, 0, TOKEN_IDS.length);
        return safeCopy;
    }

    public static String getTokenName(int id) {
        if (id > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException(TOKEN_ID_EXCEPTION_PREFIX + id);
        }
        String name = TOKEN_VALUE_TO_NAME[id];
        if (name == null) {
            throw new IllegalArgumentException(TOKEN_ID_EXCEPTION_PREFIX + id);
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = TOKEN_NAME_TO_VALUE.get(name);
        if (id == null) {
            throw new IllegalArgumentException(TOKEN_NAME_EXCEPTION_PREFIX + name);
        }
        return id;
    }

    public static String getShortDescription(String name) {
        if (!TOKEN_NAME_TO_VALUE.containsKey(name)) {
            throw new IllegalArgumentException(TOKEN_NAME_EXCEPTION_PREFIX + name);
        }
        String tokenTypes = "com.puppycrawl.tools.checkstyle.api.tokentypes";
        ResourceBundle bundle = ResourceBundle.getBundle("com.puppycrawl.tools.checkstyle.api.tokentypes", Locale.ROOT);
        return bundle.getString(name);
    }

    public static boolean isCommentType(int type) {
        return type == 144 || type == 145 || type == 182 || type == 183;
    }

    public static boolean isCommentType(String type) {
        return TokenUtils.isCommentType(TokenUtils.getTokenId(type));
    }

    public static Optional<DetailAST> findFirstTokenByPredicate(DetailAST root, Predicate<DetailAST> predicate) {
        Optional<DetailAST> result = Optional.empty();
        for (DetailAST ast = root.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (!predicate.test(ast)) continue;
            result = Optional.of(ast);
            break;
        }
        return result;
    }
}

