/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.ElementNode;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class RootNode
extends AbstractNode {
    private static final String ROOT_NAME = "ROOT";
    private final DetailAST detailAst;

    public RootNode(DetailAST detailAst) {
        super((TreeInfo)new GenericTreeInfo(Configuration.newConfiguration()));
        this.detailAst = detailAst;
        if (detailAst != null) {
            this.createChildren();
        }
    }

    private void createChildren() {
        for (DetailAST currentChild = this.detailAst; currentChild != null; currentChild = currentChild.getNextSibling()) {
            ElementNode child = new ElementNode(this, this, currentChild);
            this.addChild(child);
        }
    }

    public String getAttributeValue(String namespace, String localPart) {
        throw RootNode.throwUnsupportedOperationException();
    }

    public String getLocalPart() {
        return ROOT_NAME;
    }

    public int getNodeKind() {
        return 9;
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public String getStringValue() {
        return ROOT_NAME;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        EmptyIterator.OfNodes result;
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 9: {
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 1: 
            case 12: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this);
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(new AbstractNode[this.getChildren().size()]));
                    break;
                }
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                    break;
                }
                result = EmptyIterator.OfNodes.THE_INSTANCE;
                break;
            }
            case 5: {
                result = new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
                break;
            }
            default: {
                throw RootNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return 1;
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

