/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public final class ScopeUtil {
    private ScopeUtil() {
    }

    public static Scope getScopeFromMods(DetailAST aMods) {
        Scope returnValue = Scope.PACKAGE;
        for (DetailAST token = aMods.getFirstChild(); token != null && returnValue == Scope.PACKAGE; token = token.getNextSibling()) {
            if ("public".equals(token.getText())) {
                returnValue = Scope.PUBLIC;
                continue;
            }
            if ("protected".equals(token.getText())) {
                returnValue = Scope.PROTECTED;
                continue;
            }
            if (!"private".equals(token.getText())) continue;
            returnValue = Scope.PRIVATE;
        }
        return returnValue;
    }

    public static Scope getSurroundingScope(DetailAST node) {
        Scope returnValue = null;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (TokenUtil.isTypeDeclaration(type)) {
                DetailAST mods = token.findFirstToken(5);
                Scope modScope = ScopeUtil.getScopeFromMods(mods);
                if (returnValue != null && !returnValue.isIn(modScope)) continue;
                returnValue = modScope;
                continue;
            }
            if (type != 136) continue;
            returnValue = Scope.ANONINNER;
            break;
        }
        return returnValue;
    }

    public static boolean isInClassBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 14);
    }

    public static boolean isInRecordBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 199);
    }

    public static boolean isInInterfaceBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 15);
    }

    public static boolean isInAnnotationBlock(DetailAST node) {
        return ScopeUtil.isInBlockOf(node, 157);
    }

    private static boolean isInBlockOf(DetailAST node, int tokenType) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            if (token.getType() == tokenType) {
                returnValue = true;
                continue;
            }
            if (token.getType() == 136 || TokenUtil.isTypeDeclaration(token.getType())) break;
        }
        return returnValue;
    }

    public static boolean isInInterfaceOrAnnotationBlock(DetailAST node) {
        return ScopeUtil.isInInterfaceBlock(node) || ScopeUtil.isInAnnotationBlock(node);
    }

    public static boolean isInEnumBlock(DetailAST node) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null && !returnValue; token = token.getParent()) {
            if (token.getType() == 154) {
                returnValue = true;
                continue;
            }
            if (TokenUtil.isOfType(token, 15, 157, 14, 136)) break;
        }
        return returnValue;
    }

    public static boolean isInCodeBlock(DetailAST node) {
        boolean returnValue = false;
        int[] tokenTypes = new int[]{9, 8, 11, 12, 181, 203};
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            if (!TokenUtil.isOfType(token, tokenTypes)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public static boolean isOuterMostType(DetailAST node) {
        boolean returnValue = true;
        for (DetailAST parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!TokenUtil.isTypeDeclaration(parent.getType())) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public static boolean isLocalVariableDef(DetailAST node) {
        DetailAST parent;
        boolean localVariableDef = false;
        if (node.getType() == 10) {
            parent = node.getParent();
            localVariableDef = TokenUtil.isOfType(parent, 7, 35, 156);
        }
        if (node.getType() == 21) {
            parent = node.getParent();
            boolean bl = localVariableDef = parent.getType() == 96;
        }
        if (node.getType() == 178) {
            localVariableDef = true;
        }
        return localVariableDef;
    }

    public static boolean isClassFieldDef(DetailAST node) {
        return node.getType() == 10 && !ScopeUtil.isLocalVariableDef(node);
    }

    public static boolean isInScope(DetailAST ast, Scope scope) {
        Scope surroundingScopeOfAstToken = ScopeUtil.getSurroundingScope(ast);
        return surroundingScopeOfAstToken == scope;
    }
}

