/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.ArrayList;
import java.util.List;

@StatelessCheck
public class JavadocTagContinuationIndentationCheck
extends AbstractJavadocCheck {
    public static final String MSG_KEY = "tag.continuation.indent";
    private static final int DEFAULT_INDENTATION = 4;
    private int offset = 4;

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10068};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (!JavadocTagContinuationIndentationCheck.isInlineDescription(ast)) {
            List<DetailNode> textNodes = JavadocTagContinuationIndentationCheck.getAllNewlineNodes(ast);
            for (DetailNode newlineNode : textNodes) {
                String text;
                DetailNode textNode = JavadocUtil.getNextSibling(newlineNode);
                if (textNode.getType() != 10074 || CommonUtil.isBlank((text = textNode.getText()).trim()) || text.length() > this.offset && text.substring(1, this.offset + 1).trim().isEmpty()) continue;
                this.log(textNode.getLineNumber(), MSG_KEY, this.offset);
            }
        }
    }

    private static List<DetailNode> getAllNewlineNodes(DetailNode descriptionNode) {
        ArrayList<DetailNode> textNodes = new ArrayList<DetailNode>();
        DetailNode node = JavadocUtil.getFirstChild(descriptionNode);
        while (JavadocUtil.getNextSibling(node) != null) {
            if (node.getType() == 1) {
                textNodes.add(node);
            }
            node = JavadocUtil.getNextSibling(node);
        }
        return textNodes;
    }

    private static boolean isInlineDescription(DetailNode description) {
        boolean isInline = false;
        for (DetailNode inlineTag = description.getParent(); inlineTag != null; inlineTag = inlineTag.getParent()) {
            if (inlineTag.getType() != 10072) continue;
            isInline = true;
            break;
        }
        return isInline;
    }
}

