/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.AttributeNode;
import java.util.List;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.util.Navigator;

public class ElementNode
extends AbstractNode {
    private static final String TEXT_ATTRIBUTE_NAME = "text";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private final AbstractNode root;
    private final AbstractNode parent;
    private final DetailAST detailAst;
    private final String text;
    private final int indexAmongSiblings;
    private AttributeNode attributeNode;

    public ElementNode(AbstractNode root, AbstractNode parent, DetailAST detailAst) {
        super(root.getTreeInfo());
        this.parent = parent;
        this.root = root;
        this.detailAst = detailAst;
        this.text = TokenUtil.getTokenName(detailAst.getType());
        this.indexAmongSiblings = parent.getChildren().size();
        this.setDepth(parent.getDepth() + 1);
        this.createTextAttribute();
        this.createChildren();
    }

    public int compareOrder(NodeInfo other) {
        int result = 0;
        if (other instanceof AbstractNode && (result = this.getDepth() - ((AbstractNode)other).getDepth()) == 0) {
            ElementNode[] children = this.getCommonAncestorChildren(other);
            result = children[0].indexAmongSiblings - children[1].indexAmongSiblings;
        }
        return result;
    }

    private ElementNode[] getCommonAncestorChildren(NodeInfo other) {
        ElementNode child1 = this;
        NodeInfo child2 = other;
        while (!child1.getParent().equals((Object)child2.getParent())) {
            child1 = child1.getParent();
            child2 = child2.getParent();
        }
        return new ElementNode[]{child1, (ElementNode)child2};
    }

    private void createChildren() {
        for (DetailAST currentChild = this.detailAst.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            ElementNode child = new ElementNode(this.root, this, currentChild);
            this.addChild(child);
        }
    }

    public String getAttributeValue(String namespace, String localPart) {
        String result = TEXT_ATTRIBUTE_NAME.equals(localPart) ? (this.attributeNode == null ? null : this.attributeNode.getStringValue()) : null;
        return result;
    }

    public String getLocalPart() {
        return this.text;
    }

    public int getNodeKind() {
        return 1;
    }

    public NodeInfo getParent() {
        return this.parent;
    }

    public NodeInfo getRoot() {
        return this.root;
    }

    public AxisIterator iterateAxis(int axisNumber) {
        AxisIterator result;
        switch (axisNumber) {
            case 0: {
                result = new Navigator.AncestorEnumeration((NodeInfo)this, false);
                break;
            }
            case 1: {
                result = new Navigator.AncestorEnumeration((NodeInfo)this, true);
                break;
            }
            case 2: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this.attributeNode);
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 5: {
                result = new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
                break;
            }
            case 9: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this.parent);
                break;
            }
            case 12: {
                result = SingleNodeIterator.makeIterator((NodeInfo)this);
                break;
            }
            case 7: {
                result = this.getFollowingSiblingsIterator();
                break;
            }
            case 11: {
                result = this.getPrecedingSiblingsIterator();
                break;
            }
            case 6: {
                result = new FollowingEnumeration(this);
                break;
            }
            case 10: {
                result = new Navigator.PrecedingEnumeration((NodeInfo)this, true);
                break;
            }
            default: {
                throw ElementNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return this.detailAst.getType();
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    private AxisIterator getPrecedingSiblingsIterator() {
        Object result = this.indexAmongSiblings == 0 ? EmptyIterator.ofNodes() : new ArrayIterator.OfNodes((NodeInfo[])this.getPrecedingSiblings().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
        return result;
    }

    private AxisIterator getFollowingSiblingsIterator() {
        Object result = this.indexAmongSiblings == this.parent.getChildren().size() - 1 ? EmptyIterator.ofNodes() : new ArrayIterator.OfNodes((NodeInfo[])this.getFollowingSiblings().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
        return result;
    }

    private List<AbstractNode> getFollowingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(this.indexAmongSiblings + 1, siblings.size());
    }

    private List<AbstractNode> getPrecedingSiblings() {
        List<AbstractNode> siblings = this.parent.getChildren();
        return siblings.subList(0, this.indexAmongSiblings);
    }

    private void createTextAttribute() {
        AttributeNode attribute = null;
        if (XpathUtil.supportsTextAttribute(this.detailAst)) {
            attribute = new AttributeNode(TEXT_ATTRIBUTE_NAME, XpathUtil.getTextAttributeValue(this.detailAst));
        }
        this.attributeNode = attribute;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }

    private static final class FollowingEnumeration
    implements AxisIterator {
        private AxisIterator siblingEnum;
        private AxisIterator descendEnum;

        FollowingEnumeration(NodeInfo start) {
            this.siblingEnum = start.iterateAxis(7);
        }

        public NodeInfo next() {
            NodeInfo result = null;
            if (this.descendEnum != null) {
                result = this.descendEnum.next();
            }
            if (result == null) {
                this.descendEnum = null;
                result = this.siblingEnum.next();
                if (result == null) {
                    this.siblingEnum = null;
                } else {
                    this.descendEnum = new Navigator.DescendantEnumeration(result, true, false);
                    result = this.next();
                }
            }
            return result;
        }
    }
}

