/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ArrayInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CaseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CatchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ClassDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.DoWhileHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.FinallyHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ForHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IfHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ImportHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndexHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.LabelHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.LambdaHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MemberDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ObjectBlockHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.PackageDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SlistHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.StaticInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SwitchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SwitchRuleHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SynchronizedHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.TryHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.WhileHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.YieldHandler;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HandlerFactory {
    private final Map<Integer, Constructor<?>> typeHandlers = new HashMap();
    private final Map<DetailAST, AbstractExpressionHandler> createdHandlers = new HashMap<DetailAST, AbstractExpressionHandler>();

    public HandlerFactory() {
        this.register(33, CaseHandler.class);
        this.register(89, SwitchHandler.class);
        this.register(7, SlistHandler.class);
        this.register(16, PackageDefHandler.class);
        this.register(92, ElseHandler.class);
        this.register(83, IfHandler.class);
        this.register(95, TryHandler.class);
        this.register(96, CatchHandler.class);
        this.register(97, FinallyHandler.class);
        this.register(85, DoWhileHandler.class);
        this.register(84, WhileHandler.class);
        this.register(91, ForHandler.class);
        this.register(9, MethodDefHandler.class);
        this.register(8, MethodDefHandler.class);
        this.register(14, ClassDefHandler.class);
        this.register(154, ClassDefHandler.class);
        this.register(6, ObjectBlockHandler.class);
        this.register(15, ClassDefHandler.class);
        this.register(30, ImportHandler.class);
        this.register(29, ArrayInitHandler.class);
        this.register(27, MethodCallHandler.class);
        this.register(43, MethodCallHandler.class);
        this.register(42, MethodCallHandler.class);
        this.register(22, LabelHandler.class);
        this.register(12, StaticInitHandler.class);
        this.register(11, SlistHandler.class);
        this.register(10, MemberDefHandler.class);
        this.register(136, NewHandler.class);
        this.register(24, IndexHandler.class);
        this.register(67, SynchronizedHandler.class);
        this.register(181, LambdaHandler.class);
        this.register(157, ClassDefHandler.class);
        this.register(161, MethodDefHandler.class);
        this.register(208, SwitchRuleHandler.class);
        this.register(207, YieldHandler.class);
        this.register(199, MethodDefHandler.class);
        this.register(203, MethodDefHandler.class);
    }

    private <T> void register(int type, Class<T> handlerClass) {
        Constructor<T> ctor = CommonUtil.getConstructor(handlerClass, IndentationCheck.class, DetailAST.class, AbstractExpressionHandler.class);
        this.typeHandlers.put(type, ctor);
    }

    public boolean isHandledType(int type) {
        Set<Integer> typeSet = this.typeHandlers.keySet();
        return typeSet.contains(type);
    }

    public int[] getHandledTypes() {
        Set<Integer> typeSet = this.typeHandlers.keySet();
        int[] types = new int[typeSet.size()];
        int index = 0;
        for (Integer val : typeSet) {
            types[index] = val;
            ++index;
        }
        return types;
    }

    public AbstractExpressionHandler getHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        AbstractExpressionHandler resultHandler;
        AbstractExpressionHandler handler = this.createdHandlers.get(ast);
        if (handler != null) {
            resultHandler = handler;
        } else if (ast.getType() == 27) {
            resultHandler = this.createMethodCallHandler(indentCheck, ast, parent);
        } else {
            Constructor<?> handlerCtor = this.typeHandlers.get(ast.getType());
            resultHandler = (AbstractExpressionHandler)CommonUtil.invokeConstructor(handlerCtor, indentCheck, ast, parent);
        }
        return resultHandler;
    }

    private AbstractExpressionHandler createMethodCallHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        DetailAST astNode = ast.getFirstChild();
        while (astNode.getType() == 59) {
            astNode = astNode.getFirstChild();
        }
        AbstractExpressionHandler theParent = parent;
        if (this.isHandledType(astNode.getType())) {
            theParent = this.getHandler(indentCheck, astNode, theParent);
            this.createdHandlers.put(astNode, theParent);
        }
        return new MethodCallHandler(indentCheck, ast, theParent);
    }

    public void clearCreatedHandlers() {
        this.createdHandlers.clear();
    }
}

