/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.lucene3;

import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.QueryException;
import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.jetbrains.annotations.Nullable;

public final class ResultIterator<T>
implements CloseableIterator<T> {
    private final ScoreDoc[] scoreDocs;
    private int cursor;
    private final IndexSearcher searcher;
    @Nullable
    private final FieldSelector fieldSelector;
    private final Function<Document, T> transformer;

    public ResultIterator(ScoreDoc[] scoreDocs, int offset, IndexSearcher searcher, @Nullable FieldSelector fieldSelector, Function<Document, T> transformer) {
        this.scoreDocs = (ScoreDoc[])scoreDocs.clone();
        this.cursor = offset;
        this.searcher = searcher;
        this.fieldSelector = fieldSelector;
        this.transformer = transformer;
    }

    public boolean hasNext() {
        return this.cursor != this.scoreDocs.length;
    }

    public T next() {
        try {
            Document document = this.fieldSelector != null ? this.searcher.doc(this.scoreDocs[this.cursor++].doc, this.fieldSelector) : this.searcher.doc(this.scoreDocs[this.cursor++].doc);
            return this.transformer.apply(document);
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

