/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.codegen;

import com.querydsl.codegen.DefaultEntitySerializer;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.GeneratedAnnotationResolver;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.SerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.codegen.utils.CodeWriter;
import com.querydsl.codegen.utils.model.ClassType;
import com.querydsl.codegen.utils.model.Parameter;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import com.querydsl.codegen.utils.model.TypeCategory;
import com.querydsl.codegen.utils.model.Types;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.ForeignKey;
import com.querydsl.sql.PrimaryKey;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.KeyData;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

public class MetaDataSerializer
extends DefaultEntitySerializer {
    private static final Map<Integer, String> typeConstants = new HashMap<Integer, String>();
    private final NamingStrategy namingStrategy;
    private final boolean innerClassesForKeys;
    private final Set<String> imports;
    private final Comparator<Property> columnComparator;
    private final Class<?> entityPathType;

    @Inject
    public MetaDataSerializer(TypeMappings typeMappings, NamingStrategy namingStrategy, @Named(value="innerClassesForKeys") boolean innerClassesForKeys, @Named(value="imports") Set<String> imports, @Named(value="columnComparator") Comparator<Property> columnComparator, @Named(value="entityPathType") Class<?> entityPathType, @Named(value="generatedAnnotationClass") Class<? extends Annotation> generatedAnnotationClass) {
        super(typeMappings, Collections.emptyList(), generatedAnnotationClass);
        this.namingStrategy = namingStrategy;
        this.innerClassesForKeys = innerClassesForKeys;
        this.imports = new HashSet<String>(imports);
        this.columnComparator = columnComparator;
        this.entityPathType = entityPathType;
    }

    public MetaDataSerializer(TypeMappings typeMappings, NamingStrategy namingStrategy, boolean innerClassesForKeys, Set<String> imports, Comparator<Property> columnComparator, Class<?> entityPathType) {
        this(typeMappings, namingStrategy, innerClassesForKeys, imports, columnComparator, entityPathType, GeneratedAnnotationResolver.resolveDefault());
    }

    protected void constructorsForVariables(CodeWriter writer, EntityType model) throws IOException {
        super.constructorsForVariables(writer, model);
        String localName = writer.getRawName((Type)model);
        String genericName = writer.getGenericName(true, (Type)model);
        if (!localName.equals(genericName)) {
            writer.suppressWarnings("all");
        }
        writer.beginConstructor(new Parameter[]{new Parameter("variable", (Type)Types.STRING), new Parameter("schema", (Type)Types.STRING), new Parameter("table", (Type)Types.STRING)});
        writer.line(new String[]{"super", "(", writer.getClassConstant(localName) + ", forVariable(variable), schema, table);"});
        this.constructorContent(writer, model);
        writer.end();
        writer.beginConstructor(new Parameter[]{new Parameter("variable", (Type)Types.STRING), new Parameter("schema", (Type)Types.STRING)});
        writer.line(new String[]{"super", "(", writer.getClassConstant(localName), ", ", "forVariable(variable), schema, \"", model.getData().get("table").toString(), "\");"});
        this.constructorContent(writer, model);
        writer.end();
    }

    protected void constructorContent(CodeWriter writer, EntityType model) throws IOException {
        writer.line(new String[]{"addMetadata();"});
    }

    protected void introClassHeader(CodeWriter writer, EntityType model) throws IOException {
        Type queryType = this.typeMappings.getPathType((Type)model, model, true);
        writer.line(new String[]{"@", this.generatedAnnotationClass.getSimpleName(), "(\"", ((Object)((Object)this)).getClass().getName(), "\")"});
        TypeCategory category = model.getOriginalCategory();
        if (model.equals((Object)queryType)) {
            for (Annotation annotation : model.getAnnotations()) {
                writer.annotation(annotation);
            }
        }
        writer.beginClass(queryType, (Type)new ClassType(category, this.entityPathType, new Type[]{model}), new Type[0]);
        writer.privateStaticFinal((Type)Types.LONG_P, "serialVersionUID", String.valueOf(model.hashCode()));
    }

    protected String getAdditionalConstructorParameter(EntityType model) {
        StringBuilder builder = new StringBuilder();
        if (model.getData().containsKey("schema")) {
            builder.append(", \"").append(model.getData().get("schema")).append("\"");
        } else {
            builder.append(", null");
        }
        builder.append(", \"").append(model.getData().get("table")).append("\"");
        return builder.toString();
    }

    protected void introDefaultInstance(CodeWriter writer, EntityType entityType, String defaultName) throws IOException {
        String variableName = !defaultName.isEmpty() ? defaultName : this.namingStrategy.getDefaultVariableName(entityType);
        String alias = this.namingStrategy.getDefaultAlias(entityType);
        Type queryType = this.typeMappings.getPathType((Type)entityType, entityType, true);
        writer.publicStaticFinal(queryType, variableName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
    }

    protected void introImports(CodeWriter writer, SerializerConfig config, EntityType model) throws IOException {
        super.introImports(writer, config, model);
        Collection foreignKeys = (Collection)model.getData().get(ForeignKeyData.class);
        Collection inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class);
        boolean addJavaUtilImport = false;
        if (foreignKeys != null) {
            for (KeyData keyData : foreignKeys) {
                if (((ForeignKeyData)keyData).getForeignColumns().size() <= 1) continue;
                addJavaUtilImport = true;
                break;
            }
        }
        if (inverseForeignKeys != null) {
            for (KeyData keyData : inverseForeignKeys) {
                if (((InverseForeignKeyData)keyData).getForeignColumns().size() <= 1) continue;
                addJavaUtilImport = true;
                break;
            }
        }
        if (addJavaUtilImport) {
            writer.imports(new Package[]{List.class.getPackage()});
        }
        writer.imports(new Class[]{ColumnMetadata.class, java.sql.Types.class});
        if (!this.entityPathType.getPackage().equals(ColumnMetadata.class.getPackage())) {
            writer.imports(new Class[]{this.entityPathType});
        }
        this.writeUserImports(writer);
    }

    protected void writeUserImports(CodeWriter writer) throws IOException {
        HashSet<String> packages = new HashSet<String>();
        HashSet<String> classes = new HashSet<String>();
        for (String javaImport : this.imports) {
            boolean isClass = Character.isUpperCase(javaImport.charAt(javaImport.lastIndexOf(".") + 1));
            if (isClass) {
                classes.add(javaImport);
                continue;
            }
            packages.add(javaImport);
        }
        String[] marker = new String[]{};
        writer.importPackages(packages.toArray(marker));
        writer.importClasses(classes.toArray(marker));
    }

    protected void outro(EntityType model, CodeWriter writer) throws IOException {
        writer.beginPublicMethod((Type)Types.VOID, "addMetadata", new Parameter[0]);
        ArrayList<Property> properties = new ArrayList<Property>(model.getProperties());
        if (this.columnComparator != null) {
            properties.sort(this.columnComparator);
        }
        for (Property property : properties) {
            String name = property.getEscapedName();
            ColumnMetadata metadata = (ColumnMetadata)property.getData().get("COLUMN");
            StringBuilder columnMeta = new StringBuilder();
            columnMeta.append("ColumnMetadata");
            columnMeta.append(".named(\"").append(metadata.getName()).append("\")");
            columnMeta.append(".withIndex(").append(metadata.getIndex()).append(")");
            if (metadata.hasJdbcType()) {
                Object type = String.valueOf(metadata.getJdbcType());
                if (typeConstants.containsKey(metadata.getJdbcType())) {
                    type = "Types." + typeConstants.get(metadata.getJdbcType());
                }
                columnMeta.append(".ofType(").append((String)type).append(")");
            }
            if (metadata.hasSize()) {
                columnMeta.append(".withSize(").append(metadata.getSize()).append(")");
            }
            if (metadata.getDigits() > 0) {
                columnMeta.append(".withDigits(").append(metadata.getDigits()).append(")");
            }
            if (!metadata.isNullable()) {
                columnMeta.append(".notNull()");
            }
            writer.line(new String[]{"addMetadata(", name, ", ", columnMeta.toString(), ");"});
        }
        writer.end();
        super.outro(model, writer);
    }

    protected void serializeProperties(EntityType model, SerializerConfig config, CodeWriter writer) throws IOException {
        Collection primaryKeys = (Collection)model.getData().get(PrimaryKeyData.class);
        Collection foreignKeys = (Collection)model.getData().get(ForeignKeyData.class);
        Collection inverseForeignKeys = (Collection)model.getData().get(InverseForeignKeyData.class);
        if (this.innerClassesForKeys) {
            SimpleType primaryKeyType = new SimpleType(this.namingStrategy.getPrimaryKeysClassName());
            SimpleType foreignKeysType = new SimpleType(this.namingStrategy.getForeignKeysClassName());
            if (primaryKeys != null) {
                writer.beginClass((Type)primaryKeyType);
                this.serializePrimaryKeys(model, writer, primaryKeys);
                writer.end();
            }
            if (foreignKeys != null || inverseForeignKeys != null) {
                writer.beginClass((Type)foreignKeysType);
                if (foreignKeys != null) {
                    this.serializeForeignKeys(model, writer, foreignKeys, false);
                }
                if (inverseForeignKeys != null) {
                    this.serializeForeignKeys(model, writer, inverseForeignKeys, true);
                }
                writer.end();
            }
            super.serializeProperties(model, config, writer);
            if (primaryKeys != null) {
                writer.publicFinal((Type)primaryKeyType, this.namingStrategy.getPrimaryKeysVariable(model), "new " + primaryKeyType.getSimpleName() + "()");
            }
            if (foreignKeys != null || inverseForeignKeys != null) {
                writer.publicFinal((Type)foreignKeysType, this.namingStrategy.getForeignKeysVariable(model), "new " + foreignKeysType.getSimpleName() + "()");
            }
        } else {
            super.serializeProperties(model, config, writer);
            if (primaryKeys != null) {
                this.serializePrimaryKeys(model, writer, primaryKeys);
            }
            if (foreignKeys != null) {
                this.serializeForeignKeys(model, writer, foreignKeys, false);
            }
            if (inverseForeignKeys != null) {
                this.serializeForeignKeys(model, writer, inverseForeignKeys, true);
            }
        }
    }

    protected void customField(EntityType model, Property field, SerializerConfig config, CodeWriter writer) throws IOException {
        Type queryType = this.typeMappings.getPathType(field.getType(), model, false);
        if (queryType.getPackageName().startsWith("com.querydsl")) {
            String localRawName = writer.getRawName(field.getType());
            this.serialize(model, field, queryType, writer, "create" + field.getType().getSimpleName(), new String[]{writer.getClassConstant(localRawName)});
        } else {
            super.customField(model, field, config, writer);
        }
    }

    protected void serializePrimaryKeys(EntityType model, CodeWriter writer, Collection<PrimaryKeyData> primaryKeys) throws IOException {
        for (PrimaryKeyData primaryKey : primaryKeys) {
            String fieldName = this.namingStrategy.getPropertyNameForPrimaryKey(primaryKey.getName(), model);
            StringBuilder value = new StringBuilder("createPrimaryKey(");
            boolean first = true;
            for (String column : primaryKey.getColumns()) {
                if (!first) {
                    value.append(", ");
                }
                value.append(this.namingStrategy.getPropertyName(column, model));
                first = false;
            }
            value.append(")");
            ClassType type = new ClassType(PrimaryKey.class, new Type[]{model});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }

    protected void serializeForeignKeys(EntityType model, CodeWriter writer, Collection<? extends KeyData> foreignKeys, boolean inverse) throws IOException {
        for (KeyData keyData : foreignKeys) {
            String fieldName = inverse ? this.namingStrategy.getPropertyNameForInverseForeignKey(keyData.getName(), model) : this.namingStrategy.getPropertyNameForForeignKey(keyData.getName(), model);
            StringBuilder value = new StringBuilder();
            if (inverse) {
                value.append("createInvForeignKey(");
            } else {
                value.append("createForeignKey(");
            }
            if (keyData.getForeignColumns().size() == 1) {
                value.append(this.namingStrategy.getPropertyName(keyData.getForeignColumns().get(0), model));
                value.append(", \"").append(keyData.getParentColumns().get(0)).append("\"");
            } else {
                StringBuilder local = new StringBuilder();
                StringBuilder foreign = new StringBuilder();
                for (int i = 0; i < keyData.getForeignColumns().size(); ++i) {
                    if (i > 0) {
                        local.append(", ");
                        foreign.append(", ");
                    }
                    local.append(this.namingStrategy.getPropertyName(keyData.getForeignColumns().get(i), model));
                    foreign.append("\"").append(keyData.getParentColumns().get(i)).append("\"");
                }
                value.append("Arrays.asList(").append((CharSequence)local).append("), Arrays.asList(").append((CharSequence)foreign).append(")");
            }
            value.append(")");
            ClassType type = new ClassType(ForeignKey.class, new Type[]{keyData.getType()});
            writer.publicFinal((Type)type, fieldName, value.toString());
        }
    }

    static {
        try {
            for (Field field : java.sql.Types.class.getDeclaredFields()) {
                if (!field.getType().equals(Integer.TYPE)) continue;
                typeConstants.put(field.getInt(null), field.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

