/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.parse.sql;

import com.rabbitmq.jms.parse.sql.SqlTokenType;
import com.rabbitmq.jms.parse.sql.SqlTokenValueType;
import java.util.List;

class SqlToken {
    private final SqlTokenType tokType;
    private final String tokValue;
    private final List<String> tokValueList;

    SqlToken(SqlTokenType tokType, String tokValue) {
        this(tokType, tokValue, null);
    }

    SqlToken(SqlTokenType tokType, List<String> tokValueList) {
        this(tokType, null, tokValueList);
        if (tokType.valueType() != SqlTokenValueType.LIST) {
            throw new IllegalArgumentException("type not a LIST");
        }
    }

    private SqlToken(SqlTokenType tokType, String tokValue, List<String> tokValueList) {
        this.tokType = tokType;
        this.tokValue = tokValue;
        this.tokValueList = tokValueList;
    }

    SqlTokenType type() {
        return this.tokType;
    }

    List<String> getList() {
        return this.tokValueList;
    }

    double getFloat() {
        if (this.tokType.valueType() == SqlTokenValueType.FLOAT) {
            return SqlToken.stringToFloat(this.tokValue);
        }
        return 0.0;
    }

    long getLong() {
        if (this.tokType.valueType() == SqlTokenValueType.LONG) {
            return Long.valueOf(this.tokValue);
        }
        return 0L;
    }

    long getHex() {
        if (this.tokType.valueType() == SqlTokenValueType.HEX) {
            return SqlToken.hexToLong(this.tokValue);
        }
        return 0L;
    }

    String getString() {
        if (this.tokType.valueType() == SqlTokenValueType.STRING) {
            return SqlToken.unEscape(this.tokValue);
        }
        return "";
    }

    String getIdent() {
        if (this.tokType.valueType() == SqlTokenValueType.IDENT) {
            return String.valueOf(this.tokValue);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.tokType.opCode());
        try {
            switch (this.tokType.valueType()) {
                case FLOAT: {
                    sb.append(": ").append(this.getFloat());
                    break;
                }
                case HEX: {
                    sb.append(": ").append(this.getHex());
                    break;
                }
                case IDENT: {
                    sb.append(": ").append(this.getIdent());
                    break;
                }
                case LONG: {
                    sb.append(": ").append(this.getLong());
                    break;
                }
                case STRING: {
                    sb.append(": ").append(this.tokValue);
                    break;
                }
                case LIST: {
                    sb.append(": ").append(this.tokValueList);
                    break;
                }
            }
        }
        catch (Exception e) {
            sb.append("invalid(").append(this.tokValue).append(')');
        }
        return sb.toString();
    }

    private static final String unEscape(String s) {
        int len = s.length() - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\'' && s.charAt(i + 1) == '\'') {
                ++i;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final long hexToLong(String s) {
        int len = s.length();
        long result = 0L;
        for (int i = 2; i < len; ++i) {
            result = 16L * result + SqlToken.hexVal(s.charAt(i));
        }
        return result;
    }

    private static final long hexVal(char c) {
        switch (c) {
            case '0': {
                return 0L;
            }
            case '1': {
                return 1L;
            }
            case '2': {
                return 2L;
            }
            case '3': {
                return 3L;
            }
            case '4': {
                return 4L;
            }
            case '5': {
                return 5L;
            }
            case '6': {
                return 6L;
            }
            case '7': {
                return 7L;
            }
            case '8': {
                return 8L;
            }
            case '9': {
                return 9L;
            }
            case 'A': 
            case 'a': {
                return 10L;
            }
            case 'B': 
            case 'b': {
                return 11L;
            }
            case 'C': 
            case 'c': {
                return 12L;
            }
            case 'D': 
            case 'd': {
                return 13L;
            }
            case 'E': 
            case 'e': {
                return 14L;
            }
            case 'F': 
            case 'f': {
                return 15L;
            }
        }
        return 0L;
    }

    private static final double stringToFloat(String s) {
        return Double.valueOf(s);
    }
}

