/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.jms.client.Completion;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQMessageConsumer;
import com.rabbitmq.jms.util.Abortable;
import com.rabbitmq.jms.util.TimeTracker;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MessageListenerConsumer
implements Consumer,
Abortable {
    private final Logger logger = LoggerFactory.getLogger(MessageListenerConsumer.class);
    private final Object tagLock = new Object();
    private String consTag = null;
    private final RMQMessageConsumer messageConsumer;
    private final Channel channel;
    private final MessageListener messageListener;
    private final boolean autoAck;
    private volatile Completion completion;
    private final long terminationTimeout;
    private volatile boolean rejecting;

    public MessageListenerConsumer(RMQMessageConsumer messageConsumer, Channel channel, MessageListener messageListener, long terminationTimeout) {
        this.messageConsumer = messageConsumer;
        this.channel = channel;
        this.messageListener = messageListener;
        this.autoAck = messageConsumer.isAutoAck();
        this.terminationTimeout = terminationTimeout;
        this.completion = new Completion();
        this.rejecting = this.messageConsumer.getSession().getConnection().isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConsTag() {
        Object object = this.tagLock;
        synchronized (object) {
            if (this.consTag == null) {
                this.consTag = RMQMessageConsumer.newConsumerTag();
            }
            return this.consTag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearConsTag() {
        Object object = this.tagLock;
        synchronized (object) {
            this.consTag = null;
        }
    }

    public void handleConsumeOk(String consumerTag) {
        this.logger.trace("consumerTag='{}'", (Object)consumerTag);
    }

    public void handleCancelOk(String consumerTag) {
        this.logger.trace("consumerTag='{}'", (Object)consumerTag);
        this.completion.setComplete();
    }

    public void handleCancel(String consumerTag) throws IOException {
        this.logger.trace("consumerTag='{}'", (Object)consumerTag);
        this.completion.setComplete();
    }

    public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        this.logger.trace("consumerTag='{}' envelope='{}'", (Object)consumerTag, (Object)envelope);
        if (this.rejecting) {
            long dtag = envelope.getDeliveryTag();
            this.logger.debug("basicNack: dtag='{}'", (Object)dtag);
            this.messageConsumer.getSession().explicitNack(dtag);
            return;
        }
        GetResponse response = new GetResponse(envelope, properties, body, 0);
        try {
            long dtag = envelope.getDeliveryTag();
            if (this.messageListener != null) {
                this.messageConsumer.dealWithAcknowledgements(this.autoAck, dtag);
                RMQMessage msg = RMQMessage.convertMessage(this.messageConsumer.getSession(), this.messageConsumer.getDestination(), response);
                this.messageConsumer.getSession().deliverMessage(msg, this.messageListener);
            } else {
                this.logger.debug("basicNack: dtag='{}' (null MessageListener)", (Object)dtag);
                this.messageConsumer.getSession().explicitNack(dtag);
            }
        }
        catch (JMSException x) {
            x.printStackTrace();
            throw new IOException(x);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
            throw new IOException("Interrupted while delivering message", ie);
        }
    }

    public void handleShutdownSignal(String consumerTag, ShutdownSignalException sig) {
        this.logger.trace("consumerTag='{}'", (Object)consumerTag, (Object)sig);
    }

    public void handleRecoverOk(String consumerTag) {
        this.logger.trace("consumerTag='{}'", (Object)consumerTag);
    }

    @Override
    public void abort() {
        try {
            if (!this.completion.isComplete()) {
                String cT = this.getConsTag();
                this.logger.debug("basicCancel: consumerTag='{}'", (Object)cT);
                this.channel.basicCancel(cT);
            }
        }
        catch (Exception e) {
            this.logger.debug("basicCancel threw exception", (Throwable)e);
        }
        this.rejecting = true;
        this.completion.setComplete();
    }

    @Override
    public void stop() {
        block7: {
            String cT = this.getConsTag();
            this.logger.trace("consumerTag='{}'", (Object)cT);
            TimeTracker tt = new TimeTracker(this.terminationTimeout, TimeUnit.NANOSECONDS);
            try {
                if (!this.completion.isComplete()) {
                    this.logger.debug("consumerTag='{}' basicCancel:", (Object)cT);
                    this.channel.basicCancel(cT);
                    this.completion.waitUntilComplete(tt);
                    this.clearConsTag();
                }
            }
            catch (TimeoutException te) {
                Thread.currentThread().interrupt();
            }
            catch (ShutdownSignalException sse) {
                if (!sse.isInitiatedByApplication()) {
                    this.logger.error("basicCancel (consumerTag='{}') threw exception", (Object)cT, (Object)sse);
                    throw sse;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                if (e.getMessage().equals("Unknown consumerTag")) break block7;
                this.logger.error("basicCancel (consumerTag='{}') threw unexpected exception", (Object)cT, (Object)e);
            }
        }
    }

    @Override
    public void start() {
        String cT = this.getConsTag();
        this.logger.trace("consumerTag='{}'", (Object)cT);
        this.rejecting = false;
        this.completion = new Completion();
        try {
            this.messageConsumer.basicConsume(this, cT);
        }
        catch (Exception e) {
            this.completion.setComplete();
            this.logger.error("basicConsume (consumerTag='{}') threw exception", (Object)cT, (Object)e);
        }
    }
}

