/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.admin;

import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.jms.client.RMQConnection;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQJMSSecurityException;
import com.rabbitmq.jms.util.UriCodec;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQConnectionFactory
implements javax.jms.ConnectionFactory,
Referenceable,
Serializable,
QueueConnectionFactory,
TopicConnectionFactory {
    private final Logger logger = LoggerFactory.getLogger(RMQConnectionFactory.class);
    private static final long serialVersionUID = -4953157213762979615L;
    private static final int DEFAULT_RABBITMQ_SSL_PORT = 5671;
    private static final int DEFAULT_RABBITMQ_PORT = 5672;
    private boolean ssl = false;
    private String username = "guest";
    private String password = "guest";
    private String virtualHost = "/";
    private String host = "localhost";
    private int port = -1;
    private int queueBrowserReadMax = Math.max(0, Integer.getInteger("rabbit.jms.queueBrowserReadMax", 0));
    private volatile long terminationTimeout = Long.getLong("rabbit.jms.terminationTimeout", 15000L);
    private List<String> trustedPackages = WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES;

    public Connection createConnection() throws JMSException {
        return this.createConnection(this.username, this.password);
    }

    public Connection createConnection(String username, String password) throws JMSException {
        this.logger.trace("Creating a connection for username '{}', password 'xxxxxxxx'.", (Object)username);
        this.username = username;
        this.password = password;
        ConnectionFactory factory = new ConnectionFactory();
        this.resetSsl(factory);
        RMQConnectionFactory.setRabbitUri(this.logger, this, factory, this.getUri());
        com.rabbitmq.client.Connection rabbitConnection = this.getRabbitConnection(factory);
        RMQConnection conn = new RMQConnection(rabbitConnection, this.getTerminationTimeout(), this.getQueueBrowserReadMax());
        conn.setTrustedPackages(this.trustedPackages);
        this.logger.debug("Connection {} created.", (Object)conn);
        return conn;
    }

    private com.rabbitmq.client.Connection getRabbitConnection(ConnectionFactory factory) throws JMSException {
        try {
            return factory.newConnection();
        }
        catch (SSLException ssle) {
            throw new RMQJMSSecurityException("SSL Exception establishing RabbitMQ Connection", ssle);
        }
        catch (Exception x) {
            if (x instanceof IOException) {
                IOException ioe = (IOException)x;
                String msg = ioe.getMessage();
                if (msg != null) {
                    if (msg.contains("authentication failure") || msg.contains("refused using authentication")) {
                        throw new RMQJMSSecurityException(ioe);
                    }
                    if (msg.contains("Connection refused")) {
                        throw new RMQJMSException("RabbitMQ connection was refused. RabbitMQ broker may not be available.", ioe);
                    }
                }
                throw new RMQJMSException(ioe);
            }
            if (x instanceof TimeoutException) {
                TimeoutException te = (TimeoutException)x;
                throw new RMQJMSException("Timed out establishing RabbitMQ Connection", te);
            }
            throw new RMQJMSException("Unexpected exception thrown by newConnection()", x);
        }
    }

    public String getUri() {
        StringBuilder sb = new StringBuilder(RMQConnectionFactory.scheme(this.isSsl())).append("://");
        sb.append(RMQConnectionFactory.uriUInfoEscape(this.username, this.password)).append('@');
        sb.append(RMQConnectionFactory.uriHostEscape(this.host)).append(':').append(this.getPort()).append("/");
        sb.append(RMQConnectionFactory.uriVirtualHostEscape(this.virtualHost));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RMQConnectionFactory{");
        return (this.isSsl() ? sb.append("SSL, ") : sb).append("user='").append(this.username).append("', password").append(this.password != null ? "=xxxxxxxx" : " not set").append(", host='").append(this.host).append("', port=").append(this.getPort()).append(", virtualHost='").append(this.virtualHost).append("', queueBrowserReadMax=").append(this.queueBrowserReadMax).append('}').toString();
    }

    public void setUri(String uriString) throws JMSException {
        this.logger.trace("Set connection factory parameters by URI '{}'", (Object)uriString);
        ConnectionFactory factory = new ConnectionFactory();
        RMQConnectionFactory.setRabbitUri(this.logger, this, factory, uriString);
        this.host = factory.getHost();
        this.password = factory.getPassword();
        this.port = factory.getPort();
        this.ssl = factory.isSSL();
        this.username = factory.getUsername();
        this.virtualHost = factory.getVirtualHost();
    }

    public void setTrustedPackages(List<String> value) {
        this.trustedPackages = value;
    }

    private static void setRabbitUri(Logger logger, RMQConnectionFactory rmqFactory, ConnectionFactory factory, String uriString) throws RMQJMSException {
        if (uriString != null) {
            try {
                factory.setUri(uriString);
            }
            catch (Exception e) {
                logger.error("Could not set URI on {}", (Object)rmqFactory, (Object)e);
                throw new RMQJMSException("Could not set URI on RabbitMQ connection factory.", e);
            }
        }
    }

    private void resetSsl(ConnectionFactory factory) {
        if (this.ssl) {
            try {
                factory.useSslProtocol();
            }
            catch (Exception e1) {
                this.logger.warn("Could not set SSL protocol on connection factory, {}. SSL set off.", (Object)this, (Object)e1);
                this.ssl = false;
            }
        }
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    private static String scheme(boolean isSsl) {
        return isSsl ? "amqps" : "amqp";
    }

    private static String uriUInfoEscape(String user, String pass) {
        if (null == user) {
            return null;
        }
        if (null == pass) {
            return UriCodec.encUserinfo(user, "UTF-8");
        }
        return UriCodec.encUserinfo(user + ":" + pass, "UTF-8");
    }

    private static String uriHostEscape(String host) {
        return UriCodec.encHost(host, "UTF-8");
    }

    private static String uriVirtualHostEscape(String vHost) {
        return UriCodec.encSegment(vHost, "UTF-8");
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(RMQConnectionFactory.class.getName());
        RMQConnectionFactory.addStringRefProperty(ref, "uri", this.getUri());
        RMQConnectionFactory.addIntegerRefProperty(ref, "queueBrowserReadMax", this.getQueueBrowserReadMax());
        return ref;
    }

    private static void addStringRefProperty(Reference ref, String propertyName, String value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, value);
        ref.add(ra);
    }

    private static void addIntegerRefProperty(Reference ref, String propertyName, Integer value) {
        if (value == null || propertyName == null) {
            return;
        }
        StringRefAddr ra = new StringRefAddr(propertyName, String.valueOf(value));
        ref.add(ra);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username != null) {
            this.username = username;
        } else {
            this.logger.warn("Cannot set username to null (on {})", (Object)this);
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        if (virtualHost != null) {
            this.virtualHost = virtualHost;
        } else {
            this.logger.warn("Cannot set virtualHost to null (on {})", (Object)this);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host != null) {
            this.host = host;
        } else {
            this.logger.warn("Cannot set host to null (on {})", (Object)this);
        }
    }

    public int getPort() {
        return this.port != -1 ? this.port : (this.isSsl() ? 5671 : 5672);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getTerminationTimeout() {
        return this.terminationTimeout;
    }

    public void setTerminationTimeout(long terminationTimeout) {
        this.terminationTimeout = terminationTimeout;
    }

    public int getQueueBrowserReadMax() {
        return this.queueBrowserReadMax;
    }

    public void setQueueBrowserReadMax(int queueBrowserReadMax) {
        this.queueBrowserReadMax = Math.max(0, queueBrowserReadMax);
    }
}

