/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.BrowsingConsumer;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.parse.sql.SqlEvaluator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class BrowsingMessageEnumeration
implements Enumeration<RMQMessage> {
    private static final int BROWSING_CONSUMER_TIMEOUT = 10000;
    private final Queue<RMQMessage> msgQueue;

    public BrowsingMessageEnumeration(RMQSession session, RMQDestination dest, Channel channel, SqlEvaluator evaluator, int readMax) {
        ConcurrentLinkedQueue<RMQMessage> msgQ = new ConcurrentLinkedQueue<RMQMessage>();
        BrowsingMessageEnumeration.populateQueue(msgQ, channel, session, dest, evaluator, readMax);
        this.msgQueue = msgQ;
    }

    private static void populateQueue(Queue<RMQMessage> msgQueue, Channel channel, RMQSession session, RMQDestination dest, SqlEvaluator evaluator, int readMax) {
        try {
            String destQueueName = dest.getQueueName();
            int qCount = BrowsingMessageEnumeration.getNumberOfMessages(channel, destQueueName);
            if (qCount > 0) {
                int messagesExpected = readMax <= 0 ? qCount : Math.min(readMax, qCount);
                channel.basicQos(messagesExpected);
                BrowsingConsumer bc = new BrowsingConsumer(channel, session, dest, messagesExpected, msgQueue, evaluator);
                String consumerTag = channel.basicConsume(destQueueName, (Consumer)bc);
                if (bc.finishesInTime(10000)) {
                    return;
                }
                channel.basicCancel(consumerTag);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getNumberOfMessages(Channel channel, String destQueueName) {
        try {
            int mc2 = channel.queueDeclarePassive(destQueueName).getMessageCount();
            return mc2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public boolean hasMoreElements() {
        return !this.msgQueue.isEmpty();
    }

    @Override
    public RMQMessage nextElement() {
        RMQMessage resp = this.msgQueue.poll();
        if (null == resp) {
            throw new NoSuchElementException();
        }
        return resp;
    }

    void clearQueue() {
        this.msgQueue.clear();
    }
}

