/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.util;

import com.rabbitmq.jms.util.Abortable;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AbortableHolder
implements Abortable {
    private final Queue<Abortable> abortableQueue = new ConcurrentLinkedQueue<Abortable>();
    private final boolean[] flags = new boolean[]{false, false, false};

    public void add(Abortable a) {
        this.abortableQueue.add(a);
    }

    public void remove(Abortable a) {
        this.abortableQueue.remove(a);
    }

    @Override
    public void abort() {
        this.act(Action.ABORT);
    }

    @Override
    public void start() {
        this.act(Action.START);
    }

    @Override
    public void stop() {
        this.act(Action.STOP);
    }

    private void act(Action action) {
        Abortable[] as;
        if (this.flags[action.index()]) {
            return;
        }
        this.flags[action.index()] = true;
        for (Abortable a : as = this.abortableQueue.toArray(new Abortable[this.abortableQueue.size()])) {
            action.doit(a);
        }
        this.flags[action.index()] = false;
    }

    private static enum Action {
        ABORT(0){

            @Override
            void doit(Abortable a) {
                a.abort();
            }
        }
        ,
        START(1){

            @Override
            void doit(Abortable a) {
                a.start();
            }
        }
        ,
        STOP(2){

            @Override
            void doit(Abortable a) {
                a.stop();
            }
        };

        private final int ind;

        private Action(int ind) {
            this.ind = ind;
        }

        int index() {
            return this.ind;
        }

        abstract void doit(Abortable var1);
    }
}

