/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.util;

import com.rabbitmq.jms.client.Completion;
import com.rabbitmq.jms.util.AbortedException;
import com.rabbitmq.jms.util.TimeTracker;
import com.rabbitmq.jms.util.WaiterGate;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class EntryExitManager {
    private final WaiterGate gate;
    private final Queue<Completion> entered = new ConcurrentLinkedQueue<Completion>();
    private ThreadLocal<Completion> threadCompletion = new ThreadLocal();

    private void registerEntry() {
        Completion comp = new Completion();
        this.threadCompletion.set(comp);
        this.entered.add(comp);
    }

    public EntryExitManager() {
        this.gate = new WaiterGate(false){

            @Override
            public void onEntry() {
                EntryExitManager.this.registerEntry();
            }

            @Override
            public void onAbort() {
            }
        };
    }

    public boolean isClosed() {
        return !this.gate.isOpen();
    }

    public boolean closeGate() {
        this.gate.close();
        return true;
    }

    public boolean openGate() {
        this.gate.open();
        return true;
    }

    public boolean enter(long timeout, TimeUnit unit) throws InterruptedException, AbortedException {
        return this.enter(new TimeTracker(timeout, unit));
    }

    public boolean enter(TimeTracker tt) throws InterruptedException, AbortedException {
        return this.gate.waitForOpen(tt);
    }

    public void exit() {
        Completion comp = this.threadCompletion.get();
        if (comp != null) {
            comp.setComplete();
            this.entered.remove(comp);
        }
    }

    public boolean waitToClear(long timeout, TimeUnit unit) throws InterruptedException {
        return this.waitToClear(new TimeTracker(timeout, unit));
    }

    public boolean waitToClear(TimeTracker tt) throws InterruptedException {
        LinkedList<Completion> comps = new LinkedList<Completion>(this.entered);
        if (comps.isEmpty()) {
            return true;
        }
        for (Completion c : comps) {
            try {
                if (tt.timedOut()) {
                    return false;
                }
                c.waitUntilComplete(tt);
            }
            catch (TimeoutException unused) {
                return false;
            }
        }
        return true;
    }

    public void abortWaiters() {
        this.gate.abort();
    }
}

