/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.Channel;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.BrowsingMessageEnumeration;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.ReceivingContextConsumer;
import com.rabbitmq.jms.parse.sql.SqlEvaluator;
import com.rabbitmq.jms.parse.sql.SqlParser;
import com.rabbitmq.jms.parse.sql.SqlTokenStream;
import com.rabbitmq.jms.util.RMQJMSSelectorException;
import java.util.Enumeration;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;

class BrowsingMessageQueue
implements QueueBrowser {
    private final String selector;
    private final RMQDestination dest;
    private final SqlEvaluator evaluator;
    private final RMQSession session;
    private final int queueBrowserReadMax;
    private final ReceivingContextConsumer receivingContextConsumer;

    public BrowsingMessageQueue(RMQSession session, RMQDestination dest, String selector, int queueBrowserReadMax, ReceivingContextConsumer receivingContextConsumer) throws JMSException {
        this.dest = dest;
        this.selector = selector;
        this.session = session;
        this.evaluator = BrowsingMessageQueue.setEvaluator(selector);
        this.queueBrowserReadMax = queueBrowserReadMax;
        this.receivingContextConsumer = receivingContextConsumer;
    }

    private static final SqlEvaluator setEvaluator(String selector) throws JMSException {
        if (selector == null || selector.trim().isEmpty()) {
            return null;
        }
        SqlEvaluator evaluator = new SqlEvaluator(new SqlParser(new SqlTokenStream(selector)), RMQSession.JMS_TYPE_IDENTS);
        if (!evaluator.evaluatorOk()) {
            throw new RMQJMSSelectorException(evaluator.getErrorMessage());
        }
        return evaluator;
    }

    public Queue getQueue() throws JMSException {
        return this.dest;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    public Enumeration getEnumeration() throws JMSException {
        Channel chan = this.session.getBrowsingChannel();
        BrowsingMessageEnumeration e = new BrowsingMessageEnumeration(this.session, this.dest, chan, this.evaluator, this.queueBrowserReadMax, this.receivingContextConsumer);
        this.session.closeBrowsingChannel(chan);
        return e;
    }

    public void close() throws JMSException {
    }
}

