/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQMessageProducer;
import com.rabbitmq.jms.client.Utils;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.BytesMessage;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;

class RmqJmsProducer
implements JMSProducer {
    private final Session session;
    private final MessageProducer producer;
    private final Map<String, Serializable> properties = new ConcurrentHashMap<String, Serializable>();
    private final Map<String, Serializable> headers = new ConcurrentHashMap<String, Serializable>();
    private volatile CompletionListener completionListener = null;

    RmqJmsProducer(Session session, MessageProducer producer) {
        this.session = session;
        this.producer = producer;
    }

    public JMSProducer send(Destination destination, Message message) {
        this.properties.entrySet().forEach(entry -> Utils.wrap(() -> message.setObjectProperty((String)entry.getKey(), entry.getValue())));
        this.headers.entrySet().forEach(entry -> Utils.wrap(() -> message.setObjectProperty((String)entry.getKey(), entry.getValue())));
        if (this.completionListener == null) {
            Utils.wrap(() -> this.producer.send(destination, message));
        } else {
            Utils.wrap(() -> this.producer.send(destination, message, this.completionListener));
        }
        return this;
    }

    public JMSProducer send(Destination destination, String body) {
        return this.send(destination, (Message)Utils.wrap(() -> this.session.createTextMessage(body)));
    }

    public JMSProducer send(Destination destination, Map<String, Object> body) {
        Message message = (Message)Utils.wrap(() -> {
            MapMessage m = this.session.createMapMessage();
            if (body != null) {
                for (Map.Entry entry : body.entrySet()) {
                    m.setObject((String)entry.getKey(), entry.getValue());
                }
            }
            return m;
        });
        return this.send(destination, message);
    }

    public JMSProducer send(Destination destination, byte[] body) {
        Message message = (Message)Utils.wrap(() -> {
            BytesMessage m = this.session.createBytesMessage();
            m.writeBytes(body);
            return m;
        });
        return this.send(destination, message);
    }

    public JMSProducer send(Destination destination, Serializable body) {
        return this.send(destination, (Message)Utils.wrap(() -> this.session.createObjectMessage(body)));
    }

    public JMSProducer setDisableMessageID(boolean value) {
        Utils.wrap(() -> this.producer.setDisableMessageID(value));
        return this;
    }

    public boolean getDisableMessageID() {
        return Utils.wrap(() -> this.producer.getDisableMessageID());
    }

    public JMSProducer setDisableMessageTimestamp(boolean value) {
        Utils.wrap(() -> this.producer.setDisableMessageTimestamp(value));
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        return Utils.wrap(() -> this.producer.getDisableMessageTimestamp());
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        Utils.wrap(() -> this.producer.setDeliveryMode(deliveryMode));
        return this;
    }

    public int getDeliveryMode() {
        return Utils.wrap(() -> this.producer.getDeliveryMode());
    }

    public JMSProducer setPriority(int priority) {
        Utils.wrap(() -> this.producer.setPriority(priority));
        return this;
    }

    public int getPriority() {
        return Utils.wrap(() -> this.producer.getPriority());
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        Utils.wrap(() -> this.producer.setTimeToLive(timeToLive));
        return this;
    }

    public long getTimeToLive() {
        return Utils.wrap(() -> this.producer.getTimeToLive());
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        Utils.wrap(() -> this.producer.setDeliveryDelay(deliveryDelay));
        return this;
    }

    public long getDeliveryDelay() {
        return Utils.wrap(() -> this.producer.getDeliveryDelay());
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        this.completionListener = completionListener == null && this.completionListener != null ? RMQMessageProducer.NO_OP_COMPLETION_LISTENER : completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        return this.completionListener;
    }

    public JMSProducer setProperty(String name, boolean value) {
        return this.setPropertyInternal(name, Boolean.valueOf(value));
    }

    public JMSProducer setProperty(String name, byte value) {
        return this.setPropertyInternal(name, Byte.valueOf(value));
    }

    public JMSProducer setProperty(String name, short value) {
        return this.setPropertyInternal(name, Short.valueOf(value));
    }

    public JMSProducer setProperty(String name, int value) {
        return this.setPropertyInternal(name, Integer.valueOf(value));
    }

    public JMSProducer setProperty(String name, long value) {
        return this.setPropertyInternal(name, Long.valueOf(value));
    }

    public JMSProducer setProperty(String name, float value) {
        return this.setPropertyInternal(name, Float.valueOf(value));
    }

    public JMSProducer setProperty(String name, double value) {
        return this.setPropertyInternal(name, Double.valueOf(value));
    }

    public JMSProducer setProperty(String name, String value) {
        return this.setPropertyInternal(name, (Serializable)((Object)value));
    }

    public JMSProducer setProperty(String name, Object value) {
        return this.setPropertyInternal(name, (Serializable)value);
    }

    private JMSProducer setPropertyInternal(String name, Serializable value) {
        this.properties.put(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        this.properties.clear();
        return this;
    }

    public boolean propertyExists(String name) {
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        return Utils.wrap(() -> Utils.getBooleanProperty(this.properties, name));
    }

    public byte getByteProperty(String name) {
        return Utils.wrap(() -> Utils.getByteProperty(this.properties, name));
    }

    public short getShortProperty(String name) {
        return Utils.wrap(() -> Utils.getShortProperty(this.properties, name));
    }

    public int getIntProperty(String name) {
        return Utils.wrap(() -> Utils.getIntProperty(this.properties, name));
    }

    public long getLongProperty(String name) {
        return Utils.wrap(() -> Utils.getLongProperty(this.properties, name));
    }

    public float getFloatProperty(String name) {
        return Utils.wrap(() -> Float.valueOf(Utils.getFloatProperty(this.properties, name))).floatValue();
    }

    public double getDoubleProperty(String name) {
        return Utils.wrap(() -> Utils.getDoubleProperty(this.properties, name));
    }

    public String getStringProperty(String name) {
        return Utils.wrap(() -> Utils.getStringProperty(this.properties, name));
    }

    public Object getObjectProperty(String name) {
        return this.properties.get(name);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        String id = correlationID != null ? new String(correlationID, RMQMessage.getCharset()) : null;
        return this.setHeaderInternal("rmq.jms.message.correlation.id", (Serializable)((Object)id));
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        String id = Utils.getStringProperty(this.headers, "rmq.jms.message.correlation.id");
        return id == null ? null : id.getBytes(RMQMessage.getCharset());
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        return this.setHeaderInternal("rmq.jms.message.correlation.id", (Serializable)((Object)correlationID));
    }

    public String getJMSCorrelationID() {
        return Utils.getStringProperty(this.headers, "rmq.jms.message.correlation.id");
    }

    public JMSProducer setJMSType(String type) {
        return this.setHeaderInternal("rmq.jms.message.type", (Serializable)((Object)type));
    }

    public String getJMSType() {
        return Utils.getStringProperty(this.headers, "rmq.jms.message.type");
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        return this.setHeaderInternal("rmq.jms.message.reply.to", (Serializable)replyTo);
    }

    public Destination getJMSReplyTo() {
        return (Destination)this.headers.get("rmq.jms.message.reply.to");
    }

    private JMSProducer setHeaderInternal(String name, Serializable value) {
        this.headers.put(name, value);
        return this;
    }
}

