/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client.message;

import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.ObjectMessage;

public class RMQObjectMessage
extends RMQMessage
implements ObjectMessage {
    private final List<String> trustedPackages;
    private volatile byte[] buf = null;

    public RMQObjectMessage() {
        this(WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES);
    }

    public RMQObjectMessage(List<String> trustedPackages) {
        this.trustedPackages = trustedPackages;
    }

    public void setObject(Serializable object) throws JMSException {
        if (this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        try {
            if (object == null) {
                this.buf = null;
            } else {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bout);
                out.writeObject(object);
                out.flush();
                this.buf = bout.toByteArray();
            }
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    public Serializable getObject() throws JMSException {
        return this.getObject(this.trustedPackages);
    }

    public Serializable getObject(List<String> trustedPackages) throws JMSException {
        if (this.buf == null) {
            return null;
        }
        this.loggerDebugByteArray("Deserialising object from buffer {} for {}", this.buf, "RMQObjectMessage");
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buf);
        try {
            WhiteListObjectInputStream in = new WhiteListObjectInputStream(bin, trustedPackages);
            return (Serializable)in.readObject();
        }
        catch (ClassNotFoundException x) {
            throw new RMQJMSException(x);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    @Override
    public void clearBodyInternal() throws JMSException {
        this.buf = null;
    }

    @Override
    protected void writeBody(ObjectOutput out, ByteArrayOutputStream bout) throws IOException {
        out.writeBoolean(this.buf == null);
        if (this.buf != null) {
            out.writeInt(this.buf.length);
            out.write(this.buf);
        }
    }

    @Override
    protected void readBody(ObjectInput inputStream, ByteArrayInputStream bin) throws IOException, ClassNotFoundException {
        boolean isnull = inputStream.readBoolean();
        if (!isnull) {
            this.readWholeBuffer(inputStream.readInt(), inputStream);
        }
    }

    @Override
    protected void readAmqpBody(byte[] barr) {
        throw new UnsupportedOperationException();
    }

    private void readWholeBuffer(int len, ObjectInput inputStream) throws IOException {
        this.buf = new byte[len];
        int totalBytesRead = inputStream.read(this.buf, 0, len);
        if (totalBytesRead == -1) {
            throw new IOException("ObjectMessage body too small!");
        }
        while (totalBytesRead < len) {
            int bytesRead = inputStream.read(this.buf, totalBytesRead, len - totalBytesRead);
            if (bytesRead == -1) {
                throw new IOException("ObjectMessage body too small!");
            }
            totalBytesRead += bytesRead;
        }
    }

    @Override
    protected void writeAmqpBody(ByteArrayOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static RMQMessage recreate(ObjectMessage msg) throws JMSException {
        RMQObjectMessage rmqOMsg = new RMQObjectMessage();
        RMQMessage.copyAttributes(rmqOMsg, (Message)msg);
        rmqOMsg.setObject(msg.getObject());
        return rmqOMsg;
    }

    public static RMQMessage recreate(RMQObjectMessage msg, List<String> patterns) throws JMSException {
        RMQObjectMessage rmqOMsg = new RMQObjectMessage(patterns);
        RMQMessage.copyAttributes(rmqOMsg, msg);
        rmqOMsg.setObject(msg.getObject(patterns));
        return rmqOMsg;
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        Serializable object = this.getObject();
        if (object == null) {
            return true;
        }
        return Serializable.class == c || Object.class == c || c.isInstance(this.getObject());
    }

    @Override
    protected <T> T doGetBody(Class<T> c) throws JMSException {
        return (T)this.getObject();
    }
}

