/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client.message;

import com.rabbitmq.jms.client.RMQMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class RMQTextMessage
extends RMQMessage
implements TextMessage {
    private volatile String text;

    public void setText(String string) throws JMSException {
        if (this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message has been received and is read only.");
        }
        this.text = string;
    }

    public String getText() throws JMSException {
        return this.text;
    }

    @Override
    protected void clearBodyInternal() {
        this.text = null;
    }

    @Override
    public void writeBody(ObjectOutput out, ByteArrayOutputStream bout) throws IOException {
        String text = this.text;
        out.writeBoolean(text == null);
        if (text != null) {
            byte[] ba = text.getBytes("UTF-8");
            out.writeInt(ba.length);
            out.write(ba);
        }
    }

    @Override
    protected void readBody(ObjectInput inputStream, ByteArrayInputStream bin) throws IOException, ClassNotFoundException {
        boolean isnull = inputStream.readBoolean();
        if (!isnull) {
            int len = inputStream.readInt();
            byte[] ba = new byte[len];
            inputStream.readFully(ba, 0, len);
            this.text = new String(ba, "UTF-8");
        }
    }

    @Override
    protected void readAmqpBody(byte[] barr) {
        try {
            this.text = new String(barr, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    protected <T> T doGetBody(Class<T> c) throws JMSException {
        return (T)this.getText();
    }

    @Override
    protected void writeAmqpBody(ByteArrayOutputStream out) throws IOException {
        out.write((this.text != null ? this.text : "").getBytes("UTF-8"));
    }

    public boolean isBodyAssignableTo(Class c) {
        return c.isAssignableFrom(String.class);
    }

    public static RMQMessage recreate(TextMessage msg) throws JMSException {
        RMQTextMessage rmqTMsg = new RMQTextMessage();
        RMQMessage.copyAttributes(rmqTMsg, (Message)msg);
        rmqTMsg.setText(msg.getText());
        return rmqTMsg;
    }
}

