/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.jms.admin.RMQDestination;
import com.rabbitmq.jms.client.PublishingListener;
import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.client.RMQSession;
import com.rabbitmq.jms.client.SendingContext;
import com.rabbitmq.jms.client.SendingContextConsumer;
import com.rabbitmq.jms.client.message.RMQBytesMessage;
import com.rabbitmq.jms.client.message.RMQTextMessage;
import com.rabbitmq.jms.util.RMQJMSException;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMQMessageProducer
implements MessageProducer,
QueueSender,
TopicPublisher {
    private final Logger logger = LoggerFactory.getLogger(RMQMessageProducer.class);
    private static final String DIRECT_REPLY_TO = "amq.rabbitmq.reply-to";
    static final CompletionListener NO_OP_COMPLETION_LISTENER = new CompletionListener(){

        public void onCompletion(Message message) {
        }

        public void onException(Message message, Exception exception) {
        }
    };
    private final RMQDestination destination;
    private final RMQSession session;
    private int deliveryMode = 2;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int priority = 4;
    private long ttl = 0L;
    private long deliveryDelay = 0L;
    private final SendingStrategy sendingStrategy;
    private final BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser;
    private final SendingContextConsumer sendingContextConsumer;
    private final BeforePublishingCallback beforePublishingCallback;
    private final boolean keepTextMessageType;
    private final AtomicBoolean publishConfirmedEnabled = new AtomicBoolean(false);
    private static final long MAX_TTL = 0xFFFFFFFFL;

    RMQMessageProducer(RMQSession session, RMQDestination destination, boolean preferProducerMessageProperty, BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser, SendingContextConsumer sendingContextConsumer, PublishingListener publishingListener, boolean keepTextMessageType) {
        this.session = session;
        this.destination = destination;
        this.sendingStrategy = preferProducerMessageProperty ? new PreferMessageProducerPropertySendingStategy() : new PreferMessagePropertySendingStrategy();
        this.amqpPropertiesCustomiser = amqpPropertiesCustomiser == null ? (builder, message) -> builder : amqpPropertiesCustomiser;
        this.sendingContextConsumer = sendingContextConsumer == null ? ctx -> {} : sendingContextConsumer;
        this.beforePublishingCallback = publishingListener == null ? (message, completionListener, channel) -> {} : (message, completionListener, channel) -> publishingListener.publish(message, completionListener, channel.getNextPublishSeqNo());
        this.keepTextMessageType = keepTextMessageType;
    }

    public RMQMessageProducer(RMQSession session, RMQDestination destination, boolean preferProducerMessageProperty, BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser, SendingContextConsumer sendingContextConsumer) {
        this(session, destination, preferProducerMessageProperty, amqpPropertiesCustomiser, sendingContextConsumer, null, false);
    }

    public RMQMessageProducer(RMQSession session, RMQDestination destination, boolean preferProducerMessageProperty, BiFunction<AMQP.BasicProperties.Builder, Message, AMQP.BasicProperties.Builder> amqpPropertiesCustomiser) {
        this(session, destination, preferProducerMessageProperty, amqpPropertiesCustomiser, ctx -> {});
    }

    public RMQMessageProducer(RMQSession session, RMQDestination destination, boolean preferProducerMessageProperty) {
        this(session, destination, preferProducerMessageProperty, (builder, message) -> builder);
    }

    public RMQMessageProducer(RMQSession session, RMQDestination destination) {
        this(session, destination, true);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.disableMessageID = value;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.disableMessageTimestamp = value;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.deliveryMode = deliveryMode;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.priority = defaultPriority;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.ttl = timeToLive;
    }

    public long getTimeToLive() throws JMSException {
        return this.ttl;
    }

    public Destination getDestination() throws JMSException {
        return this.destination;
    }

    public void close() throws JMSException {
        this.logger.trace("close producer for destination '{}'", (Object)this.destination);
        this.session.removeProducer(this);
    }

    protected void internalClose() {
    }

    public void send(Message message) throws JMSException {
        this.sendingStrategy.send(this.destination, message, NO_OP_COMPLETION_LISTENER);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send(this.destination, message, NO_OP_COMPLETION_LISTENER, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.checkUnidentifiedMessageProducer(destination);
        this.sendingStrategy.send(destination, message, NO_OP_COMPLETION_LISTENER);
    }

    private void checkUnidentifiedMessageProducer(Destination destination) {
        if (destination != null && this.destination != null) {
            throw new UnsupportedOperationException("Must not supply a destination unless MessageProducer is unidentified.");
        }
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.checkUnidentifiedMessageProducer(destination);
        this.sendingStrategy.send(destination, message, NO_OP_COMPLETION_LISTENER, deliveryMode, priority, timeToLive);
    }

    private void internalSend(RMQDestination destination, Message message, CompletionListener completionListener, int deliveryMode, int priority, long timeToLiveOrExpiration, MessageExpirationType messageExpirationType, DeliveryTimeSource deliveryTimeSource) throws JMSException {
        long ttl;
        long expiration;
        this.logger.trace("send/publish message({}) to destination({}) with properties deliveryMode({}), priority({}), timeToLive({}), deliveryTimeSource({})", new Object[]{message, destination, deliveryMode, priority, timeToLiveOrExpiration, deliveryTimeSource});
        this.sendingContextConsumer.accept(new SendingContext(destination, message));
        if (destination == null) {
            destination = this.destination;
        }
        if (destination == null) {
            throw new InvalidDestinationException("No destination supplied, or implied.");
        }
        if (deliveryMode != 2) {
            deliveryMode = 1;
        }
        RMQMessage rmqMessage = RMQMessage.normalise(message);
        long currentTime = System.currentTimeMillis();
        if (messageExpirationType == MessageExpirationType.TTL) {
            expiration = timeToLiveOrExpiration == 0L ? 0L : currentTime + timeToLiveOrExpiration;
            ttl = timeToLiveOrExpiration;
        } else {
            expiration = timeToLiveOrExpiration;
            ttl = timeToLiveOrExpiration - currentTime;
        }
        rmqMessage.setJMSDeliveryMode(deliveryMode);
        rmqMessage.setJMSPriority(priority);
        rmqMessage.setJMSExpiration(expiration);
        rmqMessage.setJMSDestination(destination);
        rmqMessage.setJMSTimestamp(currentTime);
        rmqMessage.generateInternalID();
        long deliveryDelay = this.getDeliveryDelayAndSetJMSDeliveryTimeIfNeeded(rmqMessage, deliveryTimeSource);
        if (destination.isAmqp()) {
            this.sendAMQPMessage(destination, rmqMessage, message, completionListener, deliveryMode, priority, ttl, deliveryDelay);
        } else {
            this.sendJMSMessage(destination, rmqMessage, message, completionListener, deliveryMode, priority, ttl, deliveryDelay);
        }
    }

    private long getDeliveryDelayAndSetJMSDeliveryTimeIfNeeded(RMQMessage rmqMessage, DeliveryTimeSource deliveryTimeSource) throws JMSException {
        long deliveryDelay = 0L;
        long currentTime = System.currentTimeMillis();
        if (DeliveryTimeSource.MESSAGE.equals((Object)deliveryTimeSource) || this.getDeliveryDelay() <= 0L) {
            deliveryDelay = rmqMessage.getJMSDeliveryTime() - currentTime;
        } else if (this.getDeliveryDelay() > 0L) {
            deliveryDelay = this.getDeliveryDelay();
            rmqMessage.setJMSDeliveryTime(currentTime + this.getDeliveryDelay());
        }
        return deliveryDelay;
    }

    private void sendAMQPMessage(RMQDestination destination, RMQMessage msg, Message originalMessage, CompletionListener completionListener, int deliveryMode, int priority, long timeToLive, long deliveryDelay) throws JMSException {
        if (!destination.amqpWritable()) {
            this.logger.error("Cannot write to AMQP destination {}", (Object)destination);
            throw new RMQJMSException("Cannot write to AMQP destination", new UnsupportedOperationException("MessageProducer.send to undefined AMQP resource"));
        }
        if (msg instanceof RMQBytesMessage || msg instanceof RMQTextMessage) {
            try {
                AMQP.BasicProperties.Builder bob = new AMQP.BasicProperties.Builder();
                bob.contentType("application/octet-stream");
                bob.deliveryMode(Integer.valueOf(RMQMessage.rmqDeliveryMode(deliveryMode)));
                bob.priority(Integer.valueOf(priority));
                bob.expiration(RMQMessageProducer.rmqExpiration(timeToLive));
                Map<String, Object> messageHeaders = msg.toAmqpHeaders();
                if (this.keepTextMessageType && msg instanceof RMQTextMessage) {
                    messageHeaders.put("JMSType", "TextMessage");
                }
                String targetAmqpExchangeName = this.session.delayMessage(destination, messageHeaders, deliveryDelay);
                bob.headers(messageHeaders);
                RMQMessageProducer.maybeSetReplyToPropertyToDirectReplyTo(bob, msg);
                bob = this.amqpPropertiesCustomiser.apply(bob, msg);
                byte[] data = msg.toAmqpByteArray();
                this.beforePublishingCallback.beforePublishing(originalMessage, completionListener, this.session.getChannel());
                this.session.getChannel().basicPublish(targetAmqpExchangeName, destination.getAmqpRoutingKey(), bob.build(), data);
            }
            catch (IOException x) {
                throw new RMQJMSException(x);
            }
        } else {
            this.logger.error("Unsupported message type {} for AMQP destination {}", (Object)msg.getClass().getName(), (Object)destination);
            throw new RMQJMSException("Unsupported message type for AMQP destination", new UnsupportedOperationException("MessageProducer.send to AMQP resource: Message not Text or Bytes"));
        }
    }

    protected void sendJMSMessage(RMQDestination destination, RMQMessage msg, Message originalMessage, CompletionListener completionListener, int deliveryMode, int priority, long timeToLive, long deliveryDelay) throws JMSException {
        this.session.declareDestinationIfNecessary(destination);
        try {
            AMQP.BasicProperties.Builder bob = new AMQP.BasicProperties.Builder();
            bob.contentType("application/octet-stream");
            bob.deliveryMode(Integer.valueOf(RMQMessage.rmqDeliveryMode(deliveryMode)));
            bob.priority(Integer.valueOf(priority));
            bob.expiration(RMQMessageProducer.rmqExpiration(timeToLive));
            Map<String, Object> headers = msg.toHeaders();
            String targetAmqpExchangeName = this.session.delayMessage(destination, headers, deliveryDelay);
            bob.headers(headers);
            RMQMessageProducer.maybeSetReplyToPropertyToDirectReplyTo(bob, msg);
            byte[] data = msg.toByteArray();
            this.beforePublishingCallback.beforePublishing(originalMessage, completionListener, this.session.getChannel());
            this.session.getChannel().basicPublish(targetAmqpExchangeName, destination.getAmqpRoutingKey(), bob.build(), data);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    private static void maybeSetReplyToPropertyToDirectReplyTo(AMQP.BasicProperties.Builder builder, RMQMessage msg) throws JMSException {
        RMQDestination replyTo;
        if (msg.getJMSReplyTo() != null && msg.getJMSReplyTo() instanceof RMQDestination && DIRECT_REPLY_TO.equals((replyTo = (RMQDestination)msg.getJMSReplyTo()).getDestinationName())) {
            builder.replyTo(DIRECT_REPLY_TO);
        }
    }

    private static final String rmqExpiration(long ttl) {
        if (ttl == 0L) {
            return null;
        }
        return String.valueOf(ttl < 0L ? 0L : (ttl > 0xFFFFFFFFL ? 0xFFFFFFFFL : ttl));
    }

    public Queue getQueue() throws JMSException {
        return this.destination;
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send((Destination)queue, message, NO_OP_COMPLETION_LISTENER, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.sendingStrategy.send((Destination)queue, message, NO_OP_COMPLETION_LISTENER);
    }

    public Topic getTopic() throws JMSException {
        return this.destination;
    }

    public void publish(Message message) throws JMSException {
        this.sendingStrategy.send((Destination)this.getTopic(), message, NO_OP_COMPLETION_LISTENER);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send((Destination)this.getTopic(), message, NO_OP_COMPLETION_LISTENER, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.sendingStrategy.send((Destination)topic, message, NO_OP_COMPLETION_LISTENER);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendingStrategy.send((Destination)topic, message, NO_OP_COMPLETION_LISTENER, deliveryMode, priority, timeToLive);
    }

    public void setDeliveryDelay(long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        RMQMessageProducer.checkCompletionListenerNotNull(completionListener);
        this.enablePublishConfirm();
        this.sendingStrategy.send(this.destination, message, completionListener);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        RMQMessageProducer.checkCompletionListenerNotNull(completionListener);
        this.enablePublishConfirm();
        this.sendingStrategy.send(this.destination, message, completionListener, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        this.checkUnidentifiedMessageProducer(destination);
        RMQMessageProducer.checkCompletionListenerNotNull(completionListener);
        this.enablePublishConfirm();
        this.sendingStrategy.send(destination, message, completionListener);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        this.checkUnidentifiedMessageProducer(destination);
        RMQMessageProducer.checkCompletionListenerNotNull(completionListener);
        this.enablePublishConfirm();
        this.sendingStrategy.send(destination, message, completionListener, deliveryMode, priority, timeToLive);
    }

    private static void checkCompletionListenerNotNull(CompletionListener completionListener) {
        if (completionListener == null) {
            throw new IllegalArgumentException("The completion listener cannot be null");
        }
    }

    private void enablePublishConfirm() throws JMSException {
        if (this.publishConfirmedEnabled.compareAndSet(false, true)) {
            try {
                this.session.enablePublishConfirmOnChannel();
            }
            catch (IOException e) {
                throw new RMQJMSException(e);
            }
        }
    }

    static interface BeforePublishingCallback {
        public void beforePublishing(Message var1, CompletionListener var2, Channel var3);
    }

    private static enum MessageExpirationType {
        TTL,
        EXPIRATION;

    }

    private class PreferMessagePropertySendingStrategy
    implements SendingStrategy {
        private PreferMessagePropertySendingStrategy() {
        }

        @Override
        public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, completionListener, message.propertyExists("rmq.jms.message.delivery.mode") ? message.getJMSDeliveryMode() : RMQMessageProducer.this.getDeliveryMode(), message.propertyExists("rmq.jms.message.priority") ? message.getJMSPriority() : RMQMessageProducer.this.getPriority(), message.propertyExists("rmq.jms.message.expiration") ? message.getJMSExpiration() : RMQMessageProducer.this.getTimeToLive(), message.propertyExists("rmq.jms.message.expiration") ? MessageExpirationType.EXPIRATION : MessageExpirationType.TTL, message.propertyExists("rmq.jms.message.delivery.type") ? DeliveryTimeSource.MESSAGE : DeliveryTimeSource.PRODUCER);
        }

        @Override
        public void send(Destination destination, Message message, CompletionListener completionListener, int deliveryMode, int priority, long timeToLive) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, completionListener, deliveryMode, priority, timeToLive, MessageExpirationType.TTL, DeliveryTimeSource.MESSAGE);
        }
    }

    private class PreferMessageProducerPropertySendingStategy
    implements SendingStrategy {
        private PreferMessageProducerPropertySendingStategy() {
        }

        @Override
        public void send(Destination destination, Message message, CompletionListener completionListener) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, completionListener, RMQMessageProducer.this.getDeliveryMode(), RMQMessageProducer.this.getPriority(), RMQMessageProducer.this.getTimeToLive(), MessageExpirationType.TTL, DeliveryTimeSource.PRODUCER);
        }

        @Override
        public void send(Destination destination, Message message, CompletionListener completionListener, int deliveryMode, int priority, long timeToLive) throws JMSException {
            RMQMessageProducer.this.internalSend((RMQDestination)destination, message, completionListener, deliveryMode, priority, timeToLive, MessageExpirationType.TTL, DeliveryTimeSource.PRODUCER);
        }
    }

    private static enum DeliveryTimeSource {
        MESSAGE,
        PRODUCER;

    }

    private static interface SendingStrategy {
        public void send(Destination var1, Message var2, CompletionListener var3) throws JMSException;

        public void send(Destination var1, Message var2, CompletionListener var3, int var4, int var5, long var6) throws JMSException;
    }
}

