/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client.message;

import com.rabbitmq.jms.client.RMQMessage;
import com.rabbitmq.jms.util.RMQJMSException;
import com.rabbitmq.jms.util.RMQMessageFormatException;
import com.rabbitmq.jms.util.WhiteListObjectInputStream;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.StreamMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.UTFDataFormatException;
import java.util.List;

public class RMQStreamMessage
extends RMQMessage
implements StreamMessage {
    private static final byte[] EOF_ARRAY = new byte[0];
    private volatile boolean reading;
    private transient ObjectInputStream in;
    private transient ByteArrayInputStream bin;
    private transient ObjectOutputStream out;
    private transient ByteArrayOutputStream bout;
    private volatile transient byte[] buf;
    private volatile transient byte[] readbuf = null;
    private final List<String> trustedPackages;

    public RMQStreamMessage(List<String> trustedPackages) {
        this(false, trustedPackages);
    }

    public RMQStreamMessage() {
        this(false, WhiteListObjectInputStream.DEFAULT_TRUSTED_PACKAGES);
    }

    private RMQStreamMessage(boolean reading, List<String> trustedPackages) {
        this.reading = reading;
        this.trustedPackages = trustedPackages;
        if (!reading) {
            this.bout = new ByteArrayOutputStream(RMQMessage.DEFAULT_MESSAGE_BODY_SIZE);
            try {
                this.out = new ObjectOutputStream(this.bout);
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
    }

    private void writePrimitive(Object value) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        try {
            RMQMessage.writePrimitive(value, this.out);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    private Object readPrimitiveType(Class<?> type) throws JMSException {
        if (!this.reading) {
            throw new MessageNotReadableException("Message not readable");
        }
        if (this.readbuf != null) {
            throw new MessageFormatException("You must call 'int readBytes(byte[])' since the buffer is not empty");
        }
        boolean success = true;
        try {
            this.bin.mark(0);
            Object o = RMQMessage.readPrimitive(this.in);
            if (o instanceof byte[]) {
                if (type == ByteArray.class || type == Object.class) {
                    Object object = o;
                    return object;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte[]"));
            }
            if (type == ByteArray.class) {
                if (o == null) {
                    Object var4_11 = null;
                    return var4_11;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte[]"));
            }
            if (type == Boolean.class) {
                if (o == null) {
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                if (o instanceof Boolean) {
                    Object object = o;
                    return object;
                }
                if (o instanceof String) {
                    Boolean bl = Boolean.parseBoolean((String)o);
                    return bl;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "boolean"));
            }
            if (type == Byte.class) {
                if (o instanceof Byte) {
                    Object object = o;
                    return object;
                }
                if (o instanceof String) {
                    Byte by = Byte.parseByte((String)o);
                    return by;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte"));
            }
            if (type == Short.class) {
                if (o instanceof Byte) {
                    Short s = (short)((Byte)o);
                    return s;
                }
                if (o instanceof Short) {
                    Object object = o;
                    return object;
                }
                if (o instanceof String) {
                    Short s = Short.parseShort((String)o);
                    return s;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "byte"));
            }
            if (type == Integer.class) {
                if (o instanceof Byte) {
                    Integer n = (int)((Byte)o);
                    return n;
                }
                if (o instanceof Short) {
                    Integer n = (int)((Short)o);
                    return n;
                }
                if (o instanceof Integer) {
                    Object object = o;
                    return object;
                }
                if (o instanceof String) {
                    Integer n = Integer.parseInt((String)o);
                    return n;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "int"));
            }
            if (type == Character.class) {
                if (o instanceof Character) {
                    Object object = o;
                    return object;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "char"));
            }
            if (type == Long.class) {
                if (o instanceof Byte) {
                    Long l = (long)((Byte)o);
                    return l;
                }
                if (o instanceof Short) {
                    Long l = (long)((Short)o);
                    return l;
                }
                if (o instanceof Integer) {
                    Long l = (long)((Integer)o);
                    return l;
                }
                if (o instanceof Long) {
                    Object object = o;
                    return object;
                }
                if (o instanceof String) {
                    Long l = Long.parseLong((String)o);
                    return l;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "long"));
            }
            if (type == Float.class) {
                if (o instanceof Float) {
                    Float f = (Float)o;
                    return f;
                }
                if (o instanceof String) {
                    Float f = Float.valueOf(Float.parseFloat((String)o));
                    return f;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "float"));
            }
            if (type == Double.class) {
                if (o instanceof Float) {
                    Double d = ((Float)o).floatValue();
                    return d;
                }
                if (o instanceof Double) {
                    Double d = (Double)o;
                    return d;
                }
                if (o instanceof String) {
                    Double d = Double.parseDouble((String)o);
                    return d;
                }
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "double"));
            }
            if (type == String.class) {
                if (o == null) {
                    Object var4_35 = null;
                    return var4_35;
                }
                if (o instanceof byte[]) {
                    throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, "String"));
                }
                String string = o.toString();
                return string;
            }
            if (type == Object.class) {
                Object object = o;
                return object;
            }
            try {
                throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", o, type.toString()));
            }
            catch (NumberFormatException x) {
                success = false;
                throw x;
            }
            catch (ClassNotFoundException x) {
                success = false;
                throw new RMQJMSException(x);
            }
            catch (EOFException x) {
                success = false;
                throw new MessageEOFException("Message EOF");
            }
            catch (UTFDataFormatException x) {
                success = false;
                throw new RMQMessageFormatException(x);
            }
            catch (IOException x) {
                success = false;
                throw new RMQJMSException(x);
            }
            catch (Exception x) {
                success = false;
                if (x instanceof JMSException) {
                    throw (JMSException)((Object)x);
                }
                throw new RMQJMSException(x);
            }
        }
        finally {
            if (!success) {
                this.bin.reset();
            }
        }
    }

    public boolean readBoolean() throws JMSException {
        return (Boolean)this.readPrimitiveType(Boolean.class);
    }

    public byte readByte() throws JMSException {
        return (Byte)this.readPrimitiveType(Byte.class);
    }

    public short readShort() throws JMSException {
        return (Short)this.readPrimitiveType(Short.class);
    }

    public char readChar() throws JMSException {
        return ((Character)this.readPrimitiveType(Character.class)).charValue();
    }

    public int readInt() throws JMSException {
        return (Integer)this.readPrimitiveType(Integer.class);
    }

    public long readLong() throws JMSException {
        return (Long)this.readPrimitiveType(Long.class);
    }

    public float readFloat() throws JMSException {
        return ((Float)this.readPrimitiveType(Float.class)).floatValue();
    }

    public double readDouble() throws JMSException {
        return (Double)this.readPrimitiveType(Double.class);
    }

    public String readString() throws JMSException {
        return (String)this.readPrimitiveType(String.class);
    }

    public int readBytes(byte[] value) throws JMSException {
        if (this.readbuf == null) {
            this.readbuf = (byte[])this.readPrimitiveType(ByteArray.class);
            if (this.readbuf == null) {
                return -1;
            }
        }
        if (this.readbuf != null) {
            if (this.readbuf == EOF_ARRAY) {
                this.readbuf = null;
                return -1;
            }
            if (this.readbuf.length > value.length) {
                int result = value.length;
                int diff = this.readbuf.length - result;
                System.arraycopy(this.readbuf, 0, value, 0, result);
                byte[] tmp = new byte[diff];
                System.arraycopy(this.readbuf, result, tmp, 0, diff);
                this.readbuf = tmp;
                return result;
            }
            int result = Math.min(this.readbuf.length, value.length);
            System.arraycopy(this.readbuf, 0, value, 0, result);
            this.readbuf = (byte[])(result == value.length ? EOF_ARRAY : null);
            return result;
        }
        throw new MessageFormatException(String.format("Unable to cast the object, %s, into the specified type %s", null, "byte[]"));
    }

    public Object readObject() throws JMSException {
        return this.readPrimitiveType(Object.class);
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeByte(byte value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeShort(short value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeChar(char value) throws JMSException {
        this.writePrimitive(Character.valueOf(value));
    }

    public void writeInt(int value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeLong(long value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeFloat(float value) throws JMSException {
        this.writePrimitive(Float.valueOf(value));
    }

    public void writeDouble(double value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeString(String value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.writePrimitive(value);
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        byte[] buf = new byte[length];
        System.arraycopy(value, offset, buf, 0, length);
        this.writePrimitive(buf);
    }

    public void writeObject(Object value) throws JMSException {
        this.writeObject(value, false);
    }

    private void writeObject(Object value, boolean allowSerializable) throws JMSException {
        if (this.reading || this.isReadonlyBody()) {
            throw new MessageNotWriteableException("Message not writeable");
        }
        try {
            RMQMessage.writePrimitive(value, this.out, allowSerializable);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
    }

    public void reset() throws JMSException {
        this.readbuf = null;
        if (this.reading) {
            try {
                this.bin = new ByteArrayInputStream(this.buf);
                this.in = new ObjectInputStream(this.bin);
            }
            catch (IOException x) {
                throw new RMQJMSException(x);
            }
        }
        try {
            this.buf = null;
            if (this.out != null) {
                this.out.flush();
                this.buf = this.bout.toByteArray();
            } else {
                this.buf = new byte[0];
            }
            this.bin = new ByteArrayInputStream(this.buf);
            this.in = new ObjectInputStream(this.bin);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
        this.reading = true;
        this.out = null;
        this.bout = null;
    }

    @Override
    public void clearBodyInternal() throws JMSException {
        this.bout = new ByteArrayOutputStream(RMQMessage.DEFAULT_MESSAGE_BODY_SIZE);
        try {
            this.out = new ObjectOutputStream(this.bout);
        }
        catch (IOException x) {
            throw new RMQJMSException(x);
        }
        this.bin = null;
        this.in = null;
        this.buf = null;
        this.readbuf = null;
        this.reading = false;
    }

    @Override
    protected void writeBody(ObjectOutput out, ByteArrayOutputStream bout) throws IOException {
        this.out.flush();
        byte[] buf = this.bout.toByteArray();
        out.writeInt(buf.length);
        out.write(buf);
    }

    @Override
    protected void readBody(ObjectInput inputStream, ByteArrayInputStream bin) throws IOException, ClassNotFoundException {
        int len = inputStream.readInt();
        this.buf = new byte[len];
        inputStream.read(this.buf);
        this.reading = true;
        this.bin = new ByteArrayInputStream(this.buf);
        this.in = new WhiteListObjectInputStream(this.bin, this.trustedPackages);
    }

    @Override
    protected void readAmqpBody(byte[] barr) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void writeAmqpBody(ByteArrayOutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static final RMQMessage recreate(StreamMessage msg) throws JMSException {
        RMQStreamMessage rmqSMsg = new RMQStreamMessage();
        RMQMessage.copyAttributes(rmqSMsg, (Message)msg);
        msg.reset();
        boolean endOfStream = false;
        while (!endOfStream) {
            try {
                rmqSMsg.writeObject(msg.readObject());
            }
            catch (MessageEOFException e) {
                endOfStream = true;
            }
        }
        return rmqSMsg;
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        throw new MessageFormatException("Not supported for a StreamMessage");
    }

    @Override
    protected <T> T doGetBody(Class<T> c) {
        throw new UnsupportedOperationException();
    }

    public boolean isBodyAssignableTo(Class c) {
        return false;
    }

    private static class ByteArray {
        private ByteArray() {
        }
    }
}

