/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.Configuration;
import com.relevantcodes.extentreports.DisplayOrder;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.ExtentTestInterruptedException;
import com.relevantcodes.extentreports.IReporter;
import com.relevantcodes.extentreports.LogSettings;
import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.NetworkMode;
import com.relevantcodes.extentreports.SystemInfo;
import com.relevantcodes.extentreports.model.Category;
import com.relevantcodes.extentreports.model.SuiteTimeInfo;
import com.relevantcodes.extentreports.model.Test;
import com.relevantcodes.extentreports.model.TestAttribute;
import com.relevantcodes.extentreports.utils.DateTimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Report
extends LogSettings {
    private static final Logger LOGGER = Logger.getLogger(Report.class.getName());
    private static final String INTERNAL_WARNING = "Close was called before test could end safely using EndTest.";
    private String filePath;
    private DisplayOrder displayOrder;
    private NetworkMode networkMode;
    private Boolean replaceExisting;
    private LogStatus reportStatus = LogStatus.UNKNOWN;
    private Date startedTime;
    private List<String> testRunnerLogList;
    private List<LogStatus> logStatusList;
    private List<IReporter> reporters;
    private Test test;
    private UUID reportId;
    private Boolean terminated = false;
    private Map<String, List<Test>> categoryTestMap = new HashMap<String, List<Test>>();
    private Map<String, String> configurationMap;
    protected SuiteTimeInfo suiteTimeInfo;
    protected SystemInfo systemInfo = new SystemInfo();
    protected List<ExtentTest> testList;
    protected File configFile = null;

    protected List<ExtentTest> getTestList() {
        return this.testList;
    }

    protected List<LogStatus> getLogStatusList() {
        return this.logStatusList;
    }

    protected Date getStartedTime() {
        return this.startedTime;
    }

    protected String getRunDuration() {
        return DateTimeUtil.getDiff(Calendar.getInstance().getTime(), this.startedTime);
    }

    protected List<String> getTestRunnerLogList() {
        return this.testRunnerLogList;
    }

    protected Map<String, String> getConfigurationMap() {
        return this.configurationMap;
    }

    protected Map<String, List<Test>> getCategoryTestMap() {
        return this.categoryTestMap;
    }

    protected SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    protected Map<String, String> getSystemInfoMap() {
        return this.getSystemInfo().getInfo();
    }

    protected void attach(IReporter reporter) {
        if (this.reporters == null) {
            this.reporters = new ArrayList<IReporter>();
        }
        this.reporters.add(reporter);
        reporter.start(this);
    }

    protected void detach(IReporter reporter) {
        reporter.stop();
        this.reporters.remove(reporter);
    }

    protected void addTest(Test test) {
        if (test.getEndedTime() == null) {
            test.setEndedTime(Calendar.getInstance().getTime());
        }
        Test.TestAttributeIterator<Category> catIter = test.categoryIterator();
        while (catIter.hasNext()) {
            TestAttribute category = (TestAttribute)catIter.next();
            if (!this.categoryTestMap.containsKey(category.getName())) {
                ArrayList<Test> testList = new ArrayList<Test>();
                testList.add(test);
                this.categoryTestMap.put(category.getName(), testList);
                continue;
            }
            this.categoryTestMap.get(category.getName()).add(test);
        }
        test.prepareFinalize();
        this.test = test;
        for (IReporter reporter : this.reporters) {
            reporter.addTest();
        }
        this.updateReportStatus(test.getStatus());
        this.updateReportStartedTime(test);
    }

    protected void updateTestStatusList(Test test) {
        Boolean toAdd = false;
        toAdd = test.getStatus() == LogStatus.FATAL || test.getStatus() == LogStatus.ERROR || test.getStatus() == LogStatus.WARNING || test.getStatus() == LogStatus.UNKNOWN;
        if (toAdd.booleanValue() && !this.logStatusList.contains((Object)test.getStatus())) {
            this.logStatusList.add(test.getStatus());
        }
        if (test.hasChildNodes) {
            List<Test> nodeList = test.getNodeList();
            for (Test node : nodeList) {
                this.updateTestStatusList(node);
            }
        }
    }

    private void updateReportStartedTime(Test test) {
        long testStartedTime = test.getStartedTime().getTime();
        if (this.suiteTimeInfo.getSuiteStartTimestamp() > testStartedTime) {
            this.suiteTimeInfo.setSuiteStartTimestamp(testStartedTime);
        }
    }

    protected void terminate() {
        for (ExtentTest extentTest : this.testList) {
            Test test = extentTest.getTest();
            if (test.hasEnded) continue;
            ExtentTestInterruptedException e = new ExtentTestInterruptedException(INTERNAL_WARNING);
            test.setInternalWarning(INTERNAL_WARNING);
            extentTest.log(LogStatus.FAIL, e);
            test.hasEnded = true;
            this.addTest(test);
        }
        this.flush();
        Iterator<IReporter> iter = this.reporters.iterator();
        while (iter.hasNext()) {
            iter.next().stop();
            iter.remove();
        }
        this.terminated = true;
    }

    protected void flush() {
        if (this.terminated.booleanValue()) {
            try {
                throw new IOException("Unable to write source: Stream closed.");
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Stream closed", e);
                return;
            }
        }
        for (ExtentTest test : this.getTestList()) {
            this.updateTestStatusList(test.getTest());
        }
        for (IReporter reporter : this.reporters) {
            reporter.flush();
        }
    }

    protected void loadConfig(Configuration config) {
        this.configurationMap = config.getConfigurationMap();
    }

    protected void setTestRunnerLogs(String logs) {
        this.testRunnerLogList.add(logs);
    }

    protected Test getTest() {
        return this.test;
    }

    protected void setFilePath(String filePath) {
        this.filePath = filePath;
        File reportFile = new File(filePath);
        if (!reportFile.getParentFile().exists()) {
            reportFile.getParentFile().mkdirs();
        }
    }

    protected String getFilePath() {
        return this.filePath;
    }

    protected void setReplaceExisting(Boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }

    protected Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    protected void setDisplayOrder(DisplayOrder displayOrder) {
        this.displayOrder = displayOrder;
    }

    protected DisplayOrder getDisplayOrder() {
        return this.displayOrder;
    }

    protected void setNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode;
    }

    protected NetworkMode getNetworkMode() {
        return this.networkMode;
    }

    protected UUID getId() {
        return this.reportId;
    }

    protected LogStatus getStatus() {
        return this.reportStatus;
    }

    protected SuiteTimeInfo getSuiteTimeInfo() {
        return this.suiteTimeInfo;
    }

    protected void setStartedTime(long startTime) {
        this.suiteTimeInfo.setSuiteStartTimestamp(startTime);
    }

    protected Report() {
        this.suiteTimeInfo = new SuiteTimeInfo();
        this.testRunnerLogList = new ArrayList<String>();
        this.logStatusList = new ArrayList<LogStatus>();
        this.reportId = UUID.randomUUID();
        this.startedTime = new Date(this.suiteTimeInfo.getSuiteStartTimestamp());
    }

    private void updateReportStatus(LogStatus logStatus) {
        if (this.reportStatus == LogStatus.FATAL) {
            return;
        }
        if (logStatus == LogStatus.FATAL) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.FAIL) {
            return;
        }
        if (logStatus == LogStatus.FAIL) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.ERROR) {
            return;
        }
        if (logStatus == LogStatus.ERROR) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.WARNING) {
            return;
        }
        if (logStatus == LogStatus.WARNING) {
            this.reportStatus = logStatus;
            return;
        }
        if (this.reportStatus == LogStatus.PASS) {
            return;
        }
        if (logStatus == LogStatus.PASS) {
            this.reportStatus = LogStatus.PASS;
            return;
        }
        if (this.reportStatus == LogStatus.SKIP) {
            return;
        }
        if (logStatus == LogStatus.SKIP) {
            this.reportStatus = LogStatus.SKIP;
            return;
        }
        if (this.reportStatus == LogStatus.INFO) {
            return;
        }
        if (logStatus == LogStatus.INFO) {
            this.reportStatus = LogStatus.INFO;
            return;
        }
        this.reportStatus = LogStatus.UNKNOWN;
    }
}

